/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public abstract class MavenGeneralConfigurable
implements SearchableConfigurable {
    private JCheckBox checkboxWorkOffline;
    private JPanel panel;
    private JComboBox outputLevelCombo;
    private JCheckBox checkboxProduceExceptionErrorMessages;
    private JComboBox checksumPolicyCombo;
    private JComboBox failPolicyCombo;
    private JComboBox pluginUpdatePolicyCombo;
    private JCheckBox checkboxUsePluginRegistry;
    private JCheckBox checkboxRecursive;
    private MavenEnvironmentForm mavenPathsForm;
    private JComboBox snapshotUpdatePolicyCombo;
    private final DefaultComboBoxModel outputLevelComboModel;
    private final DefaultComboBoxModel checksumPolicyComboModel;
    private final DefaultComboBoxModel failPolicyComboModel;
    private final DefaultComboBoxModel snapshotUpdatePolicyComboModel;
    private final DefaultComboBoxModel pluginUpdatePolicyComboModel;

    protected abstract MavenGeneralSettings getState();

    protected MavenGeneralConfigurable() {
        this.$$$setupUI$$$();
        this.outputLevelComboModel = new DefaultComboBoxModel();
        this.checksumPolicyComboModel = new DefaultComboBoxModel();
        this.failPolicyComboModel = new DefaultComboBoxModel();
        this.snapshotUpdatePolicyComboModel = new DefaultComboBoxModel();
        this.pluginUpdatePolicyComboModel = new DefaultComboBoxModel();
        this.fillOutputLevelCombobox();
        this.fillChecksumPolicyCombobox();
        this.fillFailureBehaviorCombobox();
        this.fillPluginUpdatePolicyCombobox();
        this.fillSnapshotUpdatePolicyCombobox();
    }

    private void fillOutputLevelCombobox() {
        ComboBoxUtil.setModel(this.outputLevelCombo, this.outputLevelComboModel, Arrays.asList(MavenExecutionOptions.LoggingLevel.values()), new Function<MavenExecutionOptions.LoggingLevel, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.LoggingLevel> fun(MavenExecutionOptions.LoggingLevel each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillFailureBehaviorCombobox() {
        ComboBoxUtil.setModel(this.failPolicyCombo, this.failPolicyComboModel, Arrays.asList(MavenExecutionOptions.FailureMode.values()), new Function<MavenExecutionOptions.FailureMode, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.FailureMode> fun(MavenExecutionOptions.FailureMode each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillChecksumPolicyCombobox() {
        ComboBoxUtil.setModel(this.checksumPolicyCombo, this.checksumPolicyComboModel, Arrays.asList(MavenExecutionOptions.ChecksumPolicy.values()), new Function<MavenExecutionOptions.ChecksumPolicy, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.ChecksumPolicy> fun(MavenExecutionOptions.ChecksumPolicy each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillPluginUpdatePolicyCombobox() {
        ComboBoxUtil.setModel(this.pluginUpdatePolicyCombo, this.pluginUpdatePolicyComboModel, Arrays.asList(MavenExecutionOptions.PluginUpdatePolicy.values()), new Function<MavenExecutionOptions.PluginUpdatePolicy, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.PluginUpdatePolicy> fun(MavenExecutionOptions.PluginUpdatePolicy each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    private void fillSnapshotUpdatePolicyCombobox() {
        ComboBoxUtil.setModel(this.snapshotUpdatePolicyCombo, this.snapshotUpdatePolicyComboModel, Arrays.asList(MavenExecutionOptions.SnapshotUpdatePolicy.values()), new Function<MavenExecutionOptions.SnapshotUpdatePolicy, Pair<String, ?>>(){

            public Pair<String, MavenExecutionOptions.SnapshotUpdatePolicy> fun(MavenExecutionOptions.SnapshotUpdatePolicy each) {
                return Pair.create((Object)each.getDisplayString(), (Object)((Object)each));
            }
        });
    }

    public JComponent createComponent() {
        this.mavenPathsForm.createComponent();
        return this.panel;
    }

    public void disposeUIResources() {
    }

    public boolean isModified() {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(this.getState());
    }

    public void apply() {
        this.setData(this.getState());
    }

    public void reset() {
        this.getData(this.getState());
    }

    private void setData(MavenGeneralSettings data) {
        data.setWorkOffline(this.checkboxWorkOffline.isSelected());
        this.mavenPathsForm.setData(data);
        data.setPrintErrorStackTraces(this.checkboxProduceExceptionErrorMessages.isSelected());
        data.setUsePluginRegistry(this.checkboxUsePluginRegistry.isSelected());
        data.setNonRecursive(!this.checkboxRecursive.isSelected());
        data.setOutputLevel((MavenExecutionOptions.LoggingLevel)((Object)ComboBoxUtil.getSelectedValue(this.outputLevelComboModel)));
        data.setChecksumPolicy((MavenExecutionOptions.ChecksumPolicy)((Object)ComboBoxUtil.getSelectedValue(this.checksumPolicyComboModel)));
        data.setFailureBehavior((MavenExecutionOptions.FailureMode)((Object)ComboBoxUtil.getSelectedValue(this.failPolicyComboModel)));
        data.setPluginUpdatePolicy((MavenExecutionOptions.PluginUpdatePolicy)((Object)ComboBoxUtil.getSelectedValue(this.pluginUpdatePolicyComboModel)));
        data.setSnapshotUpdatePolicy((MavenExecutionOptions.SnapshotUpdatePolicy)((Object)ComboBoxUtil.getSelectedValue(this.snapshotUpdatePolicyComboModel)));
    }

    private void getData(MavenGeneralSettings data) {
        this.checkboxWorkOffline.setSelected(data.isWorkOffline());
        this.mavenPathsForm.getData(data);
        this.checkboxProduceExceptionErrorMessages.setSelected(data.isPrintErrorStackTraces());
        this.checkboxUsePluginRegistry.setSelected(data.isUsePluginRegistry());
        this.checkboxRecursive.setSelected(!data.isNonRecursive());
        ComboBoxUtil.select(this.outputLevelComboModel, (Object)data.getLoggingLevel());
        ComboBoxUtil.select(this.checksumPolicyComboModel, (Object)data.getChecksumPolicy());
        ComboBoxUtil.select(this.failPolicyComboModel, (Object)data.getFailureBehavior());
        ComboBoxUtil.select(this.pluginUpdatePolicyComboModel, (Object)data.getPluginUpdatePolicy());
        ComboBoxUtil.select(this.snapshotUpdatePolicyComboModel, (Object)data.getSnapshotUpdatePolicy());
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message("maven.tab.general", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.dialog.project.maven";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        MavenEnvironmentForm mavenEnvironmentForm;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Output level");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(66, 23), null));
        this.outputLevelCombo = jComboBox5 = new JComboBox();
        jPanel.add(jComboBox5, new GridConstraints(4, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Checksum policy");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checksumPolicyCombo = jComboBox4 = new JComboBox();
        jPanel.add(jComboBox4, new GridConstraints(5, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Multiproject build fail policy");
        jLabel3.setDisplayedMnemonic('F');
        jLabel3.setDisplayedMnemonicIndex(19);
        jPanel.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.failPolicyCombo = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(6, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Plugin update policy");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.pluginUpdatePolicyCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(8, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.checkboxWorkOffline = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox4.setText("Work offline");
        jCheckBox4.setMnemonic('O');
        jCheckBox4.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxUsePluginRegistry = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox3.setText("Use plugin registry");
        jCheckBox3.setMnemonic('R');
        jCheckBox3.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxRecursive = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("Execute goals recursively ");
        jCheckBox2.setMnemonic('G');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxProduceExceptionErrorMessages = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 0));
        jCheckBox.setAlignmentY(0.5f);
        jCheckBox.setText("Print exception stack traces");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.mavenPathsForm = mavenEnvironmentForm = new MavenEnvironmentForm();
        JComponent jComponent = mavenEnvironmentForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(9, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Snapshot update policy");
        jLabel5.setDisplayedMnemonic('S');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.snapshotUpdatePolicyCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(7, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jComboBox5);
        jLabel2.setLabelFor(jComboBox4);
        jLabel3.setLabelFor(jComboBox3);
        jLabel4.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

