/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorReadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsManagerWatcher {
    private static final int DOCUMENT_SAVE_DELAY = 1000;
    private final Project myProject;
    private final MavenProjectsTree myProjectsTree;
    private final MavenGeneralSettings myGeneralSettings;
    private final MavenProjectsProcessor myReadingProcessor;
    private final MavenEmbeddersManager myEmbeddersManager;
    private final List<VirtualFilePointer> mySettingsFilesPointers = new ArrayList<VirtualFilePointer>();
    private final List<LocalFileSystem.WatchRequest> myWatchedRoots = new ArrayList<LocalFileSystem.WatchRequest>();
    private final Set<Document> myChangedDocuments = new THashSet();
    private final MavenMergingUpdateQueue myChangedDocumentsQueue;

    public MavenProjectsManagerWatcher(Project project, MavenProjectsTree projectsTree, MavenGeneralSettings generalSettings, MavenProjectsProcessor readingProcessor, MavenEmbeddersManager embeddersManager) {
        this.myProject = project;
        this.myProjectsTree = projectsTree;
        this.myGeneralSettings = generalSettings;
        this.myReadingProcessor = readingProcessor;
        this.myEmbeddersManager = embeddersManager;
        this.myChangedDocumentsQueue = new MavenMergingUpdateQueue(this.getClass() + ": Document changes queue", 1000, false, (Disposable)this.myProject);
    }

    public synchronized void start() {
        MessageBusConnection myBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myChangedDocumentsQueue);
        myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener());
        myBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootChangesListener());
        this.myChangedDocumentsQueue.makeUserAware(this.myProject);
        this.myChangedDocumentsQueue.activate();
        DocumentAdapter myDocumentListener = new DocumentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                boolean isMavenFile;
                Document doc = event.getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(doc);
                if (file == null) {
                    return;
                }
                boolean bl = isMavenFile = file.getName().equals("pom.xml") || file.getName().equals("profiles.xml") || MavenProjectsManagerWatcher.this.isSettingsFile(file);
                if (!isMavenFile) {
                    return;
                }
                Set set = MavenProjectsManagerWatcher.this.myChangedDocuments;
                synchronized (set) {
                    MavenProjectsManagerWatcher.this.myChangedDocuments.add(doc);
                }
                MavenProjectsManagerWatcher.this.myChangedDocumentsQueue.queue(new Update(MavenProjectsManagerWatcher.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        THashSet copy;
                        Set set = MavenProjectsManagerWatcher.this.myChangedDocuments;
                        synchronized (set) {
                            copy = new THashSet((Collection)MavenProjectsManagerWatcher.this.myChangedDocuments);
                            MavenProjectsManagerWatcher.this.myChangedDocuments.clear();
                        }
                        MavenUtil.invokeLater(MavenProjectsManagerWatcher.this.myProject, new Runnable((Set)copy){
                            final /* synthetic */ Set val$copy;
                            {
                                this.val$copy = set;
                            }

                            @Override
                            public void run() {
                                new WriteAction(){

                                    protected void run(Result result) throws Throwable {
                                        for (Document each : val$copy) {
                                            PsiDocumentManager.getInstance((Project)MavenProjectsManagerWatcher.this.myProject).commitDocument(each);
                                            FileDocumentManager.getInstance().saveDocument(each);
                                        }
                                    }
                                }.execute();
                            }
                        });
                    }
                });
            }
        };
        MavenProjectsManagerWatcher.getDocumentEventMulticaster().addDocumentListener((DocumentListener)myDocumentListener, (Disposable)myBusConnection);
        final MavenGeneralSettings.Listener mySettingsPathsChangesListener = new MavenGeneralSettings.Listener(){

            @Override
            public void pathsChanged() {
                MavenProjectsManagerWatcher.this.updateSettingsFilePointers();
                MavenProjectsManagerWatcher.this.onSettingsChange();
            }
        };
        this.myGeneralSettings.addListener(mySettingsPathsChangesListener);
        Disposer.register((Disposable)this.myChangedDocumentsQueue, (Disposable)new Disposable(){

            public void dispose() {
                MavenProjectsManagerWatcher.this.myGeneralSettings.removeListener(mySettingsPathsChangesListener);
            }
        });
        this.updateSettingsFilePointers();
    }

    private void updateSettingsFilePointers() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedRoots);
        this.mySettingsFilesPointers.clear();
        this.addFilePointer(this.myGeneralSettings.getEffectiveUserSettingsIoFile());
        this.addFilePointer(this.myGeneralSettings.getEffectiveGlobalSettingsIoFile());
    }

    private void addFilePointer(File settingsFile) {
        if (settingsFile == null) {
            return;
        }
        this.myWatchedRoots.add(LocalFileSystem.getInstance().addRootToWatch(MavenProjectsManagerWatcher.getNormalizedPath(settingsFile.getParentFile()), false));
        String url = VfsUtil.pathToUrl((String)MavenProjectsManagerWatcher.getNormalizedPath(settingsFile));
        this.mySettingsFilesPointers.add(VirtualFilePointerManager.getInstance().create(url, (Disposable)this.myChangedDocumentsQueue, new VirtualFilePointerListener(){

            public void beforeValidityChanged(VirtualFilePointer[] pointers) {
            }

            public void validityChanged(VirtualFilePointer[] pointers) {
            }
        }));
    }

    private static String getNormalizedPath(File settingsFile) {
        String canonized = PathUtil.getCanonicalPath((String)settingsFile.getAbsolutePath());
        assert (canonized != null) : "cannot normalize path for: " + settingsFile;
        return FileUtil.toSystemIndependentName((String)canonized);
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myChangedDocumentsQueue);
    }

    private static EditorEventMulticaster getDocumentEventMulticaster() {
        return EditorFactory.getInstance().getEventMulticaster();
    }

    public synchronized void addManagedFilesWithProfiles(List<VirtualFile> files, List<String> explicitProfiles) {
        this.myProjectsTree.addManagedFilesWithProfiles(files, explicitProfiles);
        this.scheduleUpdateAll(true);
    }

    public synchronized void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, List<String> explicitProfiles) {
        this.myProjectsTree.resetManagedFilesAndProfiles(files, explicitProfiles);
        this.scheduleUpdateAll(true);
    }

    public synchronized void removeManagedFiles(List<VirtualFile> files) {
        this.myProjectsTree.removeManagedFiles(files);
        this.scheduleUpdateAll(true);
    }

    public synchronized void setExplicitProfiles(Collection<String> profiles) {
        this.myProjectsTree.setExplicitProfiles(profiles);
        this.scheduleUpdateAll(true);
    }

    private void scheduleUpdateAll(boolean forceImport) {
        this.scheduleUpdateAll(false, forceImport);
    }

    public void scheduleUpdateAll(boolean force, boolean forceImport) {
        Object message = forceImport ? MavenProjectsManager.FORCE_IMPORT_MESSAGE : null;
        this.myReadingProcessor.scheduleTask(new MavenProjectsProcessorReadingTask(force, this.myProjectsTree, this.myGeneralSettings, message));
    }

    public void scheduleUpdate(List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, boolean force, boolean forceImport) {
        Object message = forceImport ? MavenProjectsManager.FORCE_IMPORT_MESSAGE : null;
        this.myReadingProcessor.scheduleTask(new MavenProjectsProcessorReadingTask(filesToUpdate, filesToDelete, force, this.myProjectsTree, this.myGeneralSettings, message));
    }

    private void onSettingsChange() {
        this.myEmbeddersManager.reset();
        this.scheduleUpdateAll(true, false);
    }

    private void onSettingsXmlChange() {
        this.myGeneralSettings.localRepositoryChanged();
    }

    private boolean isPomFile(String path) {
        if (!path.endsWith("/pom.xml")) {
            return false;
        }
        return this.myProjectsTree.isPotentialProject(path);
    }

    private boolean isProfilesFile(String path) {
        String suffix = "/profiles.xml";
        if (!path.endsWith(suffix)) {
            return false;
        }
        int pos = path.lastIndexOf(suffix);
        return this.myProjectsTree.isPotentialProject(path.substring(0, pos) + "/" + "pom.xml");
    }

    private boolean isSettingsFile(String path) {
        for (VirtualFilePointer each : this.mySettingsFilesPointers) {
            VirtualFile f = each.getFile();
            if (f == null || !FileUtil.pathsEqual((String)path, (String)f.getPath())) continue;
            return true;
        }
        return false;
    }

    private boolean isSettingsFile(VirtualFile f) {
        for (VirtualFilePointer each : this.mySettingsFilesPointers) {
            if (each.getFile() != f) continue;
            return true;
        }
        return false;
    }

    private static abstract class MyFileChangeListenerBase
    implements BulkFileListener {
        private MyFileChangeListenerBase() {
        }

        protected abstract boolean isRelevant(String var1);

        protected abstract void updateFile(VirtualFile var1);

        protected abstract void deleteFile(VirtualFile var1);

        protected abstract void apply();

        public void before(List<? extends VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                VFileMoveEvent moveEvent;
                String newPath;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    this.deleteRecursively(((VFileDeleteEvent)vFileEvent).getFile());
                    continue;
                }
                if (!this.isRelevant(vFileEvent.getPath())) continue;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) continue;
                    this.deleteRecursively(((VFilePropertyChangeEvent)vFileEvent).getFile());
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent) || this.isRelevant(newPath = (moveEvent = (VFileMoveEvent)vFileEvent).getNewParent().getPath() + "/" + moveEvent.getFile().getName())) continue;
                this.deleteRecursively(moveEvent.getFile());
            }
        }

        private void deleteRecursively(VirtualFile f) {
            if (this.isRelevant(f.getPath())) {
                this.deleteFile(f);
            }
            if (f.isDirectory()) {
                List<VirtualFile> children = f instanceof NewVirtualFile ? ((NewVirtualFile)f).getInDbChildren() : Arrays.asList(f.getChildren());
                for (VirtualFile each : children) {
                    if (each == NullVirtualFile.INSTANCE) continue;
                    this.deleteRecursively(each);
                }
            }
        }

        public void after(List<? extends VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                VirtualFile newChild;
                if (!this.isRelevant(vFileEvent.getPath())) continue;
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    newChild = createEvent.getParent().findChild(createEvent.getChildName());
                    if (newChild == null) continue;
                    this.updateFile(newChild);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    newChild = copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
                    if (newChild == null) continue;
                    this.updateFile(newChild);
                    continue;
                }
                if (vFileEvent instanceof VFileContentChangeEvent) {
                    this.updateFile(((VFileContentChangeEvent)vFileEvent).getFile());
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) continue;
                    this.updateFile(((VFilePropertyChangeEvent)vFileEvent).getFile());
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                this.updateFile(((VFileMoveEvent)vFileEvent).getFile());
            }
            this.apply();
        }
    }

    private class MyFileChangeListener
    extends MyFileChangeListenerBase {
        private List<VirtualFile> filesToUpdate;
        private List<VirtualFile> filesToRemove;
        private boolean settingsHaveChanged;

        private MyFileChangeListener() {
        }

        @Override
        protected boolean isRelevant(String path) {
            return MavenProjectsManagerWatcher.this.isPomFile(path) || MavenProjectsManagerWatcher.this.isProfilesFile(path) || MavenProjectsManagerWatcher.this.isSettingsFile(path);
        }

        @Override
        protected void updateFile(VirtualFile file) {
            this.doUpdateFile(file, false);
        }

        @Override
        protected void deleteFile(VirtualFile file) {
            this.doUpdateFile(file, true);
        }

        private void doUpdateFile(VirtualFile file, boolean remove) {
            this.initLists();
            if (MavenProjectsManagerWatcher.this.isSettingsFile(file)) {
                this.settingsHaveChanged = true;
                return;
            }
            VirtualFile pom = this.getPomFileProfilesFile(file);
            if (pom != null) {
                this.filesToUpdate.add(pom);
                return;
            }
            if (remove) {
                this.filesToRemove.add(file);
            } else {
                this.filesToUpdate.add(file);
            }
        }

        private VirtualFile getPomFileProfilesFile(VirtualFile f) {
            if (!f.getName().equals("profiles.xml")) {
                return null;
            }
            return f.getParent().findChild("pom.xml");
        }

        @Override
        protected void apply() {
            if (this.areFileSetsInitialised()) {
                if (this.settingsHaveChanged) {
                    MavenProjectsManagerWatcher.this.onSettingsXmlChange();
                } else {
                    this.filesToUpdate.removeAll(this.filesToRemove);
                    MavenProjectsManagerWatcher.this.scheduleUpdate(this.filesToUpdate, this.filesToRemove, false, false);
                }
            }
            this.clearLists();
        }

        private boolean areFileSetsInitialised() {
            return this.filesToUpdate != null;
        }

        private void initLists() {
            if (this.areFileSetsInitialised()) {
                return;
            }
            this.filesToUpdate = new ArrayList<VirtualFile>();
            this.filesToRemove = new ArrayList<VirtualFile>();
            this.settingsHaveChanged = false;
        }

        private void clearLists() {
            this.filesToUpdate = null;
            this.filesToRemove = null;
        }
    }

    private class MyRootChangesListener
    implements ModuleRootListener {
        private MyRootChangesListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
        }

        public void rootsChanged(ModuleRootEvent event) {
            List<VirtualFile> existingFiles = MavenProjectsManagerWatcher.this.myProjectsTree.getProjectsFiles();
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> deletedFiles = new ArrayList<VirtualFile>();
            for (VirtualFile f : MavenProjectsManagerWatcher.this.myProjectsTree.getExistingManagedFiles()) {
                if (existingFiles.contains(f)) continue;
                newFiles.add(f);
            }
            for (VirtualFile f : existingFiles) {
                if (f.isValid()) continue;
                deletedFiles.add(f);
            }
            MavenProjectsManagerWatcher.this.scheduleUpdate(newFiles, deletedFiles, false, false);
        }
    }
}

