/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

public class MavenArtifactUtil {
    public static final String[] DEFAULT_GROUPS = new String[]{"org.apache.maven.plugins", "org.codehaus.mojo"};
    public static final String MAVEN_PLUGIN_DESCRIPTOR = "META-INF/maven/plugin.xml";
    private static final Map<File, MavenPluginInfo> ourPluginInfoCache = Collections.synchronizedMap(new THashMap());

    @Nullable
    public static MavenPluginInfo readPluginInfo(File localRepository, MavenId mavenId) {
        File file = MavenArtifactUtil.getArtifactFile(localRepository, mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion(), "jar");
        MavenPluginInfo result = ourPluginInfoCache.get(file);
        if (result == null) {
            result = MavenArtifactUtil.createPluginDocument(file);
            ourPluginInfoCache.put(file, result);
        }
        return result;
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, id, "jar");
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id, String type) {
        return MavenArtifactUtil.getArtifactFile(localRepository, id, type).exists();
    }

    public static File getArtifactFile(File localRepostiory, MavenId id, String type) {
        return MavenArtifactUtil.getArtifactFile(localRepostiory, id.getGroupId(), id.getArtifactId(), id.getVersion(), type);
    }

    public static File getArtifactFile(File localRepostiory, String groupId, String artifactId, String version, String type) {
        File dir = null;
        if (StringUtil.isEmpty((String)groupId)) {
            String each;
            String[] arr$ = DEFAULT_GROUPS;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(dir = MavenArtifactUtil.getArtifactDirectory(localRepostiory, each = arr$[i$], artifactId)).exists(); ++i$) {
            }
        } else {
            dir = MavenArtifactUtil.getArtifactDirectory(localRepostiory, groupId, artifactId);
        }
        if (StringUtil.isEmpty((String)version)) {
            version = MavenArtifactUtil.resolveVersion(dir);
        }
        return new File(dir, version + File.separator + artifactId + "-" + version + "." + type);
    }

    private static File getArtifactDirectory(File localRepository, String groupId, String artifactId) {
        String relativePath = StringUtil.replace((String)groupId, (String)".", (String)File.separator) + File.separator + artifactId;
        return new File(localRepository, relativePath);
    }

    private static String resolveVersion(File pluginDir) {
        File[] children;
        ArrayList<String> versions = new ArrayList<String>();
        try {
            children = pluginDir.listFiles();
            if (children == null) {
                return "";
            }
        }
        catch (Exception e) {
            MavenLog.LOG.warn((Throwable)e);
            return "";
        }
        for (File version : children) {
            if (!version.isDirectory()) continue;
            versions.add(version.getName());
        }
        if (versions.isEmpty()) {
            return "";
        }
        Collections.sort(versions);
        return (String)versions.get(versions.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static MavenPluginInfo createPluginDocument(File file) {
        MavenPluginInfo mavenPluginInfo;
        if (!file.exists()) {
            return null;
        }
        ZipFile jar = new ZipFile(file);
        ZipEntry entry = jar.getEntry(MAVEN_PLUGIN_DESCRIPTOR);
        if (entry == null) {
            MavenLog.LOG.info(IndicesBundle.message("repository.plugin.corrupt", file));
            return null;
        }
        InputStream is = jar.getInputStream(entry);
        try {
            byte[] bytes = FileUtil.loadBytes((InputStream)is);
            mavenPluginInfo = new MavenPluginInfo(bytes);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
                return null;
            }
        }
        is.close();
        jar.close();
        return mavenPluginInfo;
    }
}

