/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.ClassFinder;
import com.intellij.TestCaseLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestAll
implements Test {
    private static final Logger LOG;
    private TestCaseLoader myTestCaseLoader = new TestCaseLoader((ourMode & 0x10) != 0 ? "tests/testGroups.properties" : "");
    private long myStartTime = 0L;
    private final boolean myInterruptedByOutOfMemory = false;
    private boolean myInterruptedByOutOfTime = false;
    private long myLastTestStartTime = 0L;
    private String myLastTestClass;
    private int myRunTests = -1;
    private boolean mySavingMemorySnapshot;
    private static final int SAVE_MEMORY_SNAPSHOT = 1;
    private static final int START_GUARD = 2;
    private static final int RUN_GC = 4;
    private static final int CHECK_MEMORY = 8;
    private static final int FILTER_CLASSES = 16;
    public static int ourMode;
    private int myLastTestTestMethodCount = 0;
    public static final int MAX_FAILURE_TEST_COUNT = 150;

    public int countTestCases() {
        List<Class> classes = this.myTestCaseLoader.getClasses();
        int count = 0;
        for (Class aClass : classes) {
            Class testCaseClass = aClass;
            Test test = TestAll.getTest(testCaseClass);
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    private void beforeFirstTest() {
        if ((ourMode & 2) != 0) {
            Thread timeAndMemoryGuard = new Thread(){

                @Override
                public void run() {
                    System.out.println("Starting Time and Memory Guard");
                    while (true) {
                        try {
                            Thread currentThread;
                            while (true) {
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (TestAll.this.myLastTestStartTime == 0L) continue;
                                long currTime = System.currentTimeMillis();
                                long secondsSpent = (currTime - TestAll.this.myLastTestStartTime) / 1000L;
                                currentThread = TestAll.getCurrentThread();
                                if (TestAll.this.mySavingMemorySnapshot || secondsSpent <= PlatformTestCase.ourTestTime * (long)TestAll.this.myLastTestTestMethodCount) continue;
                                UsefulTestCase.printThreadDump();
                                System.out.println("Interrupting current Test (out of time)! Test class: " + TestAll.this.myLastTestClass + " Seconds spent = " + secondsSpent);
                                TestAll.this.myInterruptedByOutOfTime = true;
                                if (currentThread != null) break;
                            }
                            currentThread.interrupt();
                            if (currentThread.isInterrupted()) break;
                            currentThread.stop(new RuntimeException("Current Test Interrupted: OUT OF TIME!"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                    System.out.println("Time and Memory Guard finished.");
                }
            };
            timeAndMemoryGuard.setDaemon(true);
            timeAndMemoryGuard.start();
        }
        this.myStartTime = System.currentTimeMillis();
    }

    private static Thread getCurrentThread() {
        if (PlatformTestCase.ourTestThread != null) {
            return PlatformTestCase.ourTestThread;
        }
        if (LightPlatformTestCase.ourTestThread != null) {
            return LightPlatformTestCase.ourTestThread;
        }
        return null;
    }

    private void addErrorMessage(TestResult testResult, String message) {
        String processedTestsMessage = this.myRunTests <= 0 ? "Noone test was run" : this.myRunTests + " tests processed";
        try {
            testResult.startTest((Test)this);
            testResult.addError((Test)this, new Throwable(processedTestsMessage + " before: " + message));
            testResult.endTest((Test)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(TestResult testResult) {
        List<Class> classes = this.myTestCaseLoader.getClasses();
        int totalTests = classes.size();
        for (Class aClass : classes) {
            this.runNextTest(testResult, totalTests, aClass);
            if (!testResult.shouldStop()) continue;
            break;
        }
        TestAll.tryGc(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNextTest(TestResult testResult, int totalTests, Class testCaseClass) {
        ++this.myRunTests;
        if (!this.checkAvaliableMemory(35, testResult)) {
            testResult.stop();
            return;
        }
        if (testResult.errorCount() + testResult.failureCount() > 150) {
            this.addErrorMessage(testResult, "Too many errors. Tests stopped. Total " + this.myRunTests + " of " + totalTests + " tests run");
            testResult.stop();
            return;
        }
        if (this.myStartTime == 0L) {
            boolean ourClassLoader = this.getClass().getClassLoader().getClass().getName().startsWith("com.intellij.");
            if (!ourClassLoader) {
                this.beforeFirstTest();
            }
        } else if (this.myInterruptedByOutOfTime) {
            this.addErrorMessage(testResult, "Current Test Interrupted: OUT OF TIME! Class = " + this.myLastTestClass + " Total " + this.myRunTests + " of " + totalTests + " tests run");
            testResult.stop();
            return;
        }
        System.out.println("\nRunning " + testCaseClass.getName());
        LOG.info("Running " + testCaseClass.getName());
        Test test = TestAll.getTest(testCaseClass);
        if (test == null) {
            return;
        }
        this.myLastTestClass = null;
        this.myLastTestClass = testCaseClass.getName();
        this.myLastTestStartTime = System.currentTimeMillis();
        this.myLastTestTestMethodCount = test.countTestCases();
        try {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            test.run(testResult);
            try {
                final Application app = ApplicationManager.getApplication();
                if (app != null) {
                    app.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                app.runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        FileDocumentManager manager = FileDocumentManager.getInstance();
                                        if (manager instanceof FileDocumentManagerImpl) {
                                            ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                                        }
                                    }
                                });
                            }
                            catch (Throwable e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError && (ourMode & 1) != 0) {
                try {
                    this.mySavingMemorySnapshot = true;
                    System.out.println("OutOfMemoryError detected. Saving memory snapshot started");
                }
                finally {
                    System.out.println("Saving memory snapshot finished");
                    this.mySavingMemorySnapshot = false;
                }
            }
            testResult.addError(test, t);
        }
    }

    private boolean checkAvaliableMemory(int neededMemory, TestResult testResult) {
        if ((ourMode & 8) == 0) {
            return true;
        }
        boolean possibleOutOfMemoryError = TestAll.possibleOutOfMemory(neededMemory);
        if (possibleOutOfMemoryError) {
            TestAll.tryGc(5);
            possibleOutOfMemoryError = TestAll.possibleOutOfMemory(neededMemory);
            if (possibleOutOfMemoryError) {
                System.out.println("OutOfMemoryError: dumping memory");
                Runtime runtime = Runtime.getRuntime();
                long total = runtime.totalMemory();
                long free = runtime.freeMemory();
                String errorMessage = "Too much memory used. Total: " + total + " free: " + free + " used: " + (total - free) + "\n";
                this.addErrorMessage(testResult, errorMessage);
            }
        }
        return !possibleOutOfMemoryError;
    }

    private static boolean possibleOutOfMemory(int neededMemory) {
        long meg;
        long needed;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long realFreeMemory = runtime.freeMemory() + (maxMemory - runtime.totalMemory());
        boolean possibleOutOfMemoryError = realFreeMemory < (needed = (long)neededMemory * (meg = 0x100000L));
        return possibleOutOfMemoryError;
    }

    private static Test getTest(Class testCaseClass) {
        if ((testCaseClass.getModifiers() & 1) == 0) {
            return null;
        }
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", ArrayUtil.EMPTY_CLASS_ARRAY);
            return (Test)suiteMethod.invoke(null, (Object[])ArrayUtil.EMPTY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException e) {
            if (TestRunnerUtil.isJUnit4TestClass(testCaseClass)) {
                return new JUnit4TestAdapter(testCaseClass);
            }
            return new TestSuite(testCaseClass){

                public void addTest(Test test) {
                    if (!(test instanceof TestCase)) {
                        super.addTest(test);
                    } else {
                        Method method = this.findTestMethod((TestCase)test);
                        if (method == null || !TestCaseLoader.isBombed(method)) {
                            super.addTest(test);
                        }
                    }
                }

                private Method findTestMethod(TestCase testCase) {
                    try {
                        return testCase.getClass().getMethod(testCase.getName(), new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        return null;
                    }
                }
            };
        }
        catch (Exception e) {
            System.err.println("Failed to execute suite ()");
            e.printStackTrace();
            return null;
        }
    }

    private static String[] getClassRoots() {
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    public TestAll(String packageRoot) throws Throwable {
        this(packageRoot, TestAll.getClassRoots());
    }

    public TestAll(String packageRoot, String ... classRoots) throws IOException, ClassNotFoundException {
        this.myTestCaseLoader.addClassIfTestCase(Class.forName("_FirstInSuiteTest"));
        for (String classRoot : classRoots) {
            ClassFinder classFinder = new ClassFinder(new File(classRoot), packageRoot);
            this.myTestCaseLoader.loadTestCases(classFinder.getClasses());
        }
        System.out.println("Number of test classes found: " + this.myTestCaseLoader.getClasses().size());
    }

    public static void tryGc(int times) {
        if ((ourMode & 4) == 0) {
            return;
        }
        for (int qqq = 1; qqq < times; ++qqq) {
            try {
                Thread.sleep(qqq * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.gc();
            System.out.println("Runtime.getRuntime().totalMemory() = " + Runtime.getRuntime().totalMemory());
        }
    }

    static {
        Logger.setFactory((Logger.Factory)TestLoggerFactory.getInstance());
        LOG = Logger.getInstance((String)"#com.intellij.TestAll");
        ourMode = 19;
    }
}

