/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.HashMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

class PageSizes {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeEditor.printing.PageSizes");
    private static ArrayList myPageSizes = null;
    private static HashMap myNamesToPageSizes = null;
    private static final double MM_TO_INCH = 0.03937007874015748;
    @NonNls
    private static final String PAGE_SIZES_RESOURCE = "/PageSizes.xml";
    @NonNls
    private static final String ELEMENT_SIZE = "size";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_WIDTH = "width";
    @NonNls
    private static final String ATTRIBUTE_HEIGHT = "height";
    @NonNls
    private static final String ATTRIBUTE_UNIT = "unit";
    @NonNls
    private static final String UNIT_MM = "mm";

    PageSizes() {
    }

    public static String[] getNames() {
        PageSizes.init();
        String[] ret = new String[myPageSizes.size()];
        for (int i = 0; i < myPageSizes.size(); ++i) {
            PageSize pageSize = (PageSize)myPageSizes.get(i);
            ret[i] = pageSize.name;
        }
        return ret;
    }

    public static Object getItem(String name) {
        PageSizes.init();
        return myNamesToPageSizes.get((Object)name);
    }

    public static double getWidth(String name) {
        PageSizes.init();
        PageSize pageSize = (PageSize)myNamesToPageSizes.get((Object)name);
        if (pageSize == null) {
            return 0.0;
        }
        return pageSize.width;
    }

    public static double getHeight(String name) {
        PageSizes.init();
        PageSize pageSize = (PageSize)myNamesToPageSizes.get((Object)name);
        if (pageSize == null) {
            return 0.0;
        }
        return pageSize.height;
    }

    public static String getName(Object item) {
        PageSizes.init();
        if (!(item instanceof PageSize)) {
            return null;
        }
        PageSize pageSize = (PageSize)item;
        return pageSize.name;
    }

    private static void addPageSizeIn(String name, String dimensions, double width, double height) {
        PageSize pageSize = new PageSize();
        pageSize.name = name;
        pageSize.visualName = name + "    (" + dimensions + ")";
        pageSize.width = width;
        pageSize.height = height;
        myPageSizes.add(pageSize);
        myNamesToPageSizes.put((Object)pageSize.name, (Object)pageSize);
    }

    private static void init() {
        if (myPageSizes != null) {
            return;
        }
        myPageSizes = new ArrayList();
        myNamesToPageSizes = new HashMap();
        try {
            Document document = JDOMUtil.loadDocument((InputStream)PageSizes.class.getResourceAsStream(PAGE_SIZES_RESOURCE));
            List elements = document.getRootElement().getChildren(ELEMENT_SIZE);
            for (Element element : elements) {
                String name = element.getAttributeValue(ATTRIBUTE_NAME);
                String widthStr = element.getAttributeValue(ATTRIBUTE_WIDTH);
                String heightStr = element.getAttributeValue(ATTRIBUTE_HEIGHT);
                String unit = element.getAttributeValue(ATTRIBUTE_UNIT);
                String unitName = unit.equals(UNIT_MM) ? CodeEditorBundle.message("print.page.size.unit.mm", new Object[0]) : CodeEditorBundle.message("print.page.size.unit.in", new Object[0]);
                String dimensions = CodeEditorBundle.message("print.page.width.x.height.unit.template", widthStr, heightStr, unitName);
                double width = PageSizes.parsePageSize(widthStr);
                double height = PageSizes.parsePageSize(heightStr);
                if (unit.equals(UNIT_MM)) {
                    width *= 0.03937007874015748;
                    height *= 0.03937007874015748;
                }
                PageSizes.addPageSizeIn(name, dimensions, width, height);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static double parsePageSize(String sizeStr) {
        int slashPos = sizeStr.indexOf(47);
        if (slashPos >= 0) {
            int spacePos = sizeStr.indexOf(32);
            int intPart = Integer.valueOf(sizeStr.substring(0, spacePos));
            double numerator = Double.valueOf(sizeStr.substring(spacePos + 1, slashPos));
            double denominator = Double.valueOf(sizeStr.substring(slashPos + 1));
            return (double)intPart + numerator / denominator;
        }
        return Integer.valueOf(sizeStr).intValue();
    }

    private static class PageSize {
        public double width;
        public double height;
        public String name;
        public String visualName;

        private PageSize() {
        }

        public String toString() {
            return this.visualName;
        }
    }
}

