/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ExpressionSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionTemplateItem;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.KeywordLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInsight.template.SmartCompletionContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.getters.ClassLiteralGetter;
import com.intellij.psi.filters.getters.FilterGetter;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.filters.getters.ThisGetter;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicExpressionCompletionContributor
extends ExpressionSmartCompletionContributor {
    private static void addKeyword(CompletionResultSet result, PsiElement element, String s) {
        result.addElement(BasicExpressionCompletionContributor.createKeywordLookupItem(element, s));
    }

    public static LookupElement createKeywordLookupItem(final PsiElement element, final String s) {
        return (LookupElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LookupItem>(){

            public LookupItem compute() {
                try {
                    PsiKeyword keyword = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createKeyword(s);
                    return new KeywordLookupItem(keyword, element).setAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public BasicExpressionCompletionContributor() {
        this.extend((ElementPattern<? extends PsiElement>)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement().referencing((ElementPattern)PsiJavaPatterns.psiClass())))), new CompletionProvider<JavaSmartCompletionParameters>(){

            public void addCompletions(@NotNull JavaSmartCompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/BasicExpressionCompletionContributor$2.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/BasicExpressionCompletionContributor$2.addCompletions must not be null");
                }
                PsiElement element = parameters.getPosition();
                BasicExpressionCompletionContributor.addKeyword(result, element, "class");
                BasicExpressionCompletionContributor.addKeyword(result, element, "this");
            }
        });
        this.extend((ElementPattern<? extends PsiElement>)StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})), new CollectionsUtilityMethodsProvider());
        this.extend((ElementPattern<? extends PsiElement>)StandardPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})), new CompletionProvider<JavaSmartCompletionParameters>(){

            protected void addCompletions(@NotNull JavaSmartCompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/BasicExpressionCompletionContributor$3.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/BasicExpressionCompletionContributor$3.addCompletions must not be null");
                }
                PsiElement position = parameters.getPosition();
                final PsiType expectedType = parameters.getExpectedType();
                FilterGetter baseGetter = new FilterGetter(new ContextGetter(){

                    @Override
                    public Object[] get(PsiElement context, CompletionContext completionContext) {
                        return new Object[]{expectedType};
                    }
                }, new ExcludeDeclaredFilter(ElementClassFilter.CLASS));
                for (LookupElement lookupElement : ClassLiteralGetter.getClassLiterals(position, null, result.getPrefixMatcher(), baseGetter)) {
                    result.addElement(lookupElement);
                }
                for (TemplateImpl templateImpl : TemplateSettings.getInstance().getTemplates()) {
                    if (templateImpl.isDeactivated() || !templateImpl.getTemplateContext().isEnabled(new SmartCompletionContextType())) continue;
                    result.addElement((LookupElement)new SmartCompletionTemplateItem(templateImpl, position));
                }
                BasicExpressionCompletionContributor.addKeyword(result, position, "true");
                BasicExpressionCompletionContributor.addKeyword(result, position, "false");
                PsiElement psiElement = position.getParent();
                if (psiElement != null && !(psiElement.getParent() instanceof PsiSwitchLabelStatement)) {
                    MembersGetter.addMembers(parameters.getPosition(), expectedType, result);
                    if (!parameters.getDefaultType().equals(expectedType)) {
                        MembersGetter.addMembers(parameters.getPosition(), parameters.getDefaultType(), result);
                    }
                    for (PsiExpression expression : ThisGetter.getThisExpressionVariants(position)) {
                        result.addElement((LookupElement)new ExpressionLookupItem(expression));
                    }
                }
                BasicExpressionCompletionContributor.processDataflowExpressionTypes(position, expectedType, result.getPrefixMatcher(), new Consumer<LookupElement>(){

                    public void consume(LookupElement decorator) {
                        result.addElement(decorator);
                    }
                });
            }
        });
    }

    public static void processDataflowExpressionTypes(PsiElement position, @Nullable PsiType expectedType, final PrefixMatcher matcher, Consumer<LookupElement> consumer) {
        PsiExpression context = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiExpression.class);
        if (context == null) {
            return;
        }
        final Map<PsiExpression, PsiType> map = GuessManager.getInstance(position.getProject()).getControlFlowExpressionTypes(context);
        if (map.isEmpty()) {
            return;
        }
        PsiScopesUtil.treeWalkUp(new BaseScopeProcessor(){

            public boolean execute(PsiElement element, ResolveState state) {
                if (element instanceof PsiLocalVariable) {
                    PsiType dfaCasted;
                    PsiTypeCastExpression typeCastExpression;
                    PsiExpression operand;
                    if (!matcher.prefixMatches(((PsiLocalVariable)element).getName())) {
                        return true;
                    }
                    PsiExpression expression = ((PsiLocalVariable)element).getInitializer();
                    if (expression instanceof PsiTypeCastExpression && (operand = (typeCastExpression = (PsiTypeCastExpression)expression).getOperand()) != null && (dfaCasted = (PsiType)map.get(operand)) != null && dfaCasted.equals(typeCastExpression.getType())) {
                        map.remove(operand);
                    }
                }
                return true;
            }
        }, (PsiElement)context, (PsiElement)context.getContainingFile());
        for (PsiExpression expression : map.keySet()) {
            PsiType castType = map.get(expression);
            PsiType baseType = expression.getType();
            if (expectedType != null && (!expectedType.isAssignableFrom(castType) || baseType != null && expectedType.isAssignableFrom(baseType))) continue;
            consumer.consume((Object)CastingLookupElementDecorator.createCastingElement(BasicExpressionCompletionContributor.expressionToLookupElement(expression), castType));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static LookupElement expressionToLookupElement(@NotNull PsiExpression expression) {
        PsiMethod method;
        PsiMethodCallExpression call;
        LookupItem lookupItem;
        PsiElement target;
        PsiReferenceExpression refExpr;
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/BasicExpressionCompletionContributor.expressionToLookupElement must not be null");
        }
        if (expression instanceof PsiReferenceExpression && !(refExpr = (PsiReferenceExpression)expression).isQualified() && (target = refExpr.resolve()) instanceof PsiVariable) {
            VariableLookupItem item = new VariableLookupItem((PsiVariable)target);
            item.setSubstitutor(PsiSubstitutor.EMPTY);
            lookupItem = item;
            if (lookupItem == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/BasicExpressionCompletionContributor.expressionToLookupElement must not return null");
            return lookupItem;
        }
        if (expression instanceof PsiMethodCallExpression && !(call = (PsiMethodCallExpression)expression).getMethodExpression().isQualified() && (method = call.resolveMethod()) != null) {
            lookupItem = new JavaMethodCallElement(method);
            if (lookupItem == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/BasicExpressionCompletionContributor.expressionToLookupElement must not return null");
            return lookupItem;
        }
        lookupItem = new ExpressionLookupItem(expression);
        if (lookupItem != null) return lookupItem;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/BasicExpressionCompletionContributor.expressionToLookupElement must not return null");
    }
}

