/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;

public class CompletionContext {
    public static final Key<CompletionContext> COMPLETION_CONTEXT_KEY = Key.create((String)"CompletionContext");
    public final Project project;
    public final Editor editor;
    public final PsiFile file;
    private final OffsetMap myOffsetMap;

    public CompletionContext(Project project, Editor editor, PsiFile file, OffsetMap offsetMap) {
        this.project = project;
        this.editor = editor;
        this.file = file;
        this.myOffsetMap = offsetMap;
    }

    public int getStartOffset() {
        return this.getOffsetMap().getOffset(CompletionInitializationContext.START_OFFSET);
    }

    public void setStartOffset(int newStartOffset) {
        this.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, newStartOffset);
    }

    public int getSelectionEndOffset() {
        return this.getOffsetMap().getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    public void setSelectionEndOffset(int selectionEndOffset) {
        this.getOffsetMap().addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, selectionEndOffset);
    }

    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }
}

