/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.XmlSmartEnterProcessor");

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/XmlSmartEnterProcessor.process must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/XmlSmartEnterProcessor.process must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/XmlSmartEnterProcessor.process must not be null");
        }
        return this.completeEndTag(project, editor, psiFile);
    }

    private boolean completeEndTag(Project project, Editor editor, PsiFile psiFile) {
        PsiElement atCaret = this.getStatementAtCaret(editor, psiFile);
        XmlTag tagAtCaret = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlTag.class);
        if (tagAtCaret == null) {
            return false;
        }
        try {
            char ch;
            ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tagAtCaret.getNode());
            ASTNode endTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tagAtCaret.getNode());
            if (emptyTagEnd != null || endTagEnd != null) {
                return false;
            }
            int insertionOffset = tagAtCaret.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            int caretAt = editor.getCaretModel().getOffset();
            CharSequence text = doc.getCharsSequence();
            int probableCommaOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)insertionOffset, (String)" \t");
            PsiElement siebling = tagAtCaret.getNextSibling();
            int caretTo = caretAt;
            if (caretAt < probableCommaOffset) {
                XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                CharSequence tagNameText = null;
                if (xmlAttribute != null) {
                    ASTNode tagName;
                    ASTNode node = tagAtCaret.getNode();
                    if (node != null && (tagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node)) != null) {
                        tagNameText = tagName.getText();
                    }
                    XmlAttributeValue valueElement = xmlAttribute.getValueElement();
                    TextRange textRange = xmlAttribute.getTextRange();
                    int n = valueElement == null ? textRange.getStartOffset() : (caretAt = XmlSmartEnterProcessor.getClosingQuote(xmlAttribute).length() == 0 ? textRange.getEndOffset() : caretAt);
                }
                if (tagNameText == null) {
                    tagNameText = text.subSequence(tagAtCaret.getTextRange().getStartOffset() + 1, caretAt);
                }
                PsiElement element = psiFile.findElementAt(probableCommaOffset);
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
                String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, false);
                if (tag != null && tag.getTextRange().getStartOffset() == probableCommaOffset) {
                    doc.insertString(caretAt, (CharSequence)text2insert);
                    if (this.shouldInsertClosingTag(xmlAttribute, tagAtCaret)) {
                        doc.insertString(tag.getTextRange().getEndOffset() + text2insert.length(), (CharSequence)("</" + tagAtCaret.getName() + ">"));
                    }
                    caretTo = tag.getTextRange().getEndOffset() + text2insert.length();
                } else {
                    doc.insertString(caretAt, (CharSequence)text2insert);
                    if (this.shouldInsertClosingTag(xmlAttribute, tagAtCaret)) {
                        doc.insertString(probableCommaOffset + text2insert.length(), (CharSequence)("</" + tagNameText + ">"));
                    }
                    caretTo = probableCommaOffset + text2insert.length();
                }
            } else if (siebling instanceof XmlTag && siebling.getTextRange().getStartOffset() == caretAt) {
                XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, false);
                doc.insertString(caretAt, (CharSequence)text2insert);
                if (this.shouldInsertClosingTag(xmlAttribute, tagAtCaret)) {
                    doc.insertString(siebling.getTextRange().getEndOffset() + text2insert.length(), (CharSequence)("</" + tagAtCaret.getName() + ">"));
                }
                caretTo = siebling.getTextRange().getEndOffset() + text2insert.length();
            } else if (probableCommaOffset >= text.length() || (ch = text.charAt(probableCommaOffset)) != '/' && ch != '>') {
                XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, true);
                doc.insertString(insertionOffset, (CharSequence)text2insert);
                caretTo = insertionOffset + text2insert.length();
            }
            if (XmlSmartEnterProcessor.isUncommited((Project)project)) {
                this.commit(editor);
                tagAtCaret = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getStatementAtCaret(editor, psiFile), XmlTag.class);
                editor.getCaretModel().moveToOffset(caretTo);
            }
            this.reformat((PsiElement)tagAtCaret);
            this.commit(editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    protected boolean shouldInsertClosingTag(XmlAttribute xmlAttribute, XmlTag tagAtCaret) {
        return true;
    }

    protected String getClosingPart(XmlAttribute xmlAttribute, XmlTag tagAtCaret, boolean emptyTag) {
        return XmlSmartEnterProcessor.getClosingQuote(xmlAttribute) + (emptyTag ? "/>" : ">");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected static CharSequence getClosingQuote(@Nullable XmlAttribute attribute) {
        if (attribute == null) {
            return "";
        }
        XmlAttributeValue element = attribute.getValueElement();
        if (element == null) {
            return "";
        }
        String s = element.getText();
        if (s == null) return "";
        if (s.length() <= 0) return "";
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) != '\"') {
            return "\"";
        }
        if (s.charAt(0) != '\'') return "";
        if (s.charAt(s.length() - 1) == '\'') return "";
        return "'";
    }
}

