/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoComposite
extends HighlightInfo {
    @NonNls
    private static final String HTML_HEADER = "<html>";
    @NonNls
    private static final String BODY_HEADER = "<body>";
    @NonNls
    private static final String HTML_FOOTER = "</html>";
    @NonNls
    private static final String BODY_FOOTER = "</body>";
    @NonNls
    private static final String LINE_BREAK = "\n<hr size=1 noshade>";

    public HighlightInfoComposite(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfoComposite.<init> must not be null");
        }
        super(infos.get((int)0).type, infos.get((int)0).startOffset, infos.get((int)0).endOffset, HighlightInfoComposite.createCompositeDescription(infos), HighlightInfoComposite.createCompositeTooltip(infos));
        this.text = infos.get((int)0).text;
        this.highlighter = infos.get((int)0).highlighter;
        this.group = infos.get((int)0).group;
        this.quickFixActionMarkers = new ArrayList();
        this.quickFixActionRanges = new ArrayList();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers != null) {
                this.quickFixActionMarkers.addAll(info.quickFixActionMarkers);
            }
            if (info.quickFixActionRanges == null) continue;
            this.quickFixActionRanges.addAll(info.quickFixActionRanges);
        }
    }

    @Nullable
    private static String createCompositeDescription(List<HighlightInfo> infos) {
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo info : infos) {
            String itemDescription = info.description;
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    private static String createCompositeTooltip(List<HighlightInfo> infos) {
        StringBuilder result = new StringBuilder();
        for (HighlightInfo info : infos) {
            String toolTip = info.toolTip;
            if (toolTip == null) continue;
            if (result.length() != 0) {
                result.append(LINE_BREAK);
            }
            toolTip = StringUtil.trimStart((String)toolTip, (String)HTML_HEADER);
            toolTip = StringUtil.trimStart((String)toolTip, (String)BODY_HEADER);
            toolTip = StringUtil.trimEnd((String)toolTip, (String)HTML_FOOTER);
            toolTip = StringUtil.trimEnd((String)toolTip, (String)BODY_FOOTER);
            result.append(toolTip);
        }
        if (result.length() == 0) {
            return null;
        }
        result.insert(0, HTML_HEADER);
        result.append(HTML_FOOTER);
        return result.toString();
    }
}

