/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveNewQualifierFix
implements IntentionAction {
    private final PsiNewExpression expression;
    private final PsiClass aClass;

    public RemoveNewQualifierFix(PsiNewExpression expression, PsiClass aClass) {
        this.expression = expression;
        this.aClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix.isAvailable must not be null");
        }
        return this.expression != null && this.expression.isValid() && (this.aClass == null || this.aClass.isValid()) && this.expression.getManager().isInProject((PsiElement)this.expression);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.expression.getContainingFile())) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = this.expression.getClassReference();
        this.expression.getQualifier().delete();
        if (this.aClass != null && classReference != null) {
            classReference.bindToElement((PsiElement)this.aClass);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

