/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class EnterBetweenBracesHandler
implements EnterHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, Ref<Integer> caretOffsetRef, Ref<Integer> caretAdvance, DataContext dataContext, EditorActionHandler originalHandler) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int caretOffset = (Integer)caretOffsetRef.get();
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER && caretOffset > 0 && caretOffset < text.length() && (text.charAt(caretOffset - 1) == '(' && text.charAt(caretOffset) == ')' || text.charAt(caretOffset - 1) == '{' && text.charAt(caretOffset) == '}')) {
            originalHandler.execute(editor, dataContext);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            try {
                CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent(file, editor.getCaretModel().getOffset());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return EnterHandlerDelegate.Result.Default;
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

