/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

public class SemicolonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        PsiReturnStatement stmt;
        PsiMethod method;
        if (psiElement instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class)) != null && PsiType.VOID.equals(method.getReturnType()) && (stmt = (PsiReturnStatement)psiElement).getReturnValue() != null) {
            Document doc = editor.getDocument();
            doc.insertString(stmt.getTextRange().getStartOffset() + "return".length(), (CharSequence)";");
            return;
        }
        if (psiElement instanceof PsiExpressionStatement || psiElement instanceof PsiDeclarationStatement || psiElement instanceof PsiImportStatementBase || psiElement instanceof PsiDoWhileStatement || psiElement instanceof PsiReturnStatement || psiElement instanceof PsiThrowStatement || psiElement instanceof PsiBreakStatement || psiElement instanceof PsiContinueStatement || psiElement instanceof PsiAssertStatement || psiElement instanceof PsiField && !(psiElement instanceof PsiEnumConstant) || psiElement instanceof PsiMethod && (((PsiMethod)psiElement).getContainingClass().isInterface() || ((PsiMethod)psiElement).hasModifierProperty("abstract"))) {
            String text = psiElement.getText();
            int tailLength = 0;
            LeafElement leaf = TreeUtil.findLastLeaf(psiElement.getNode());
            while (JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(leaf.getElementType())) {
                tailLength += leaf.getTextLength();
                leaf = TreeUtil.prevLeaf(leaf);
            }
            if (tailLength > 0) {
                text = text.substring(0, text.length() - tailLength);
            }
            int insertionOffset = leaf.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            if (psiElement instanceof PsiField && ((PsiField)psiElement).hasModifierProperty("abstract")) {
                doc.insertString(insertionOffset, (CharSequence)"()");
                insertionOffset += "()".length();
            }
            if (!StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == psiElement) {
                    return;
                }
                doc.insertString(insertionOffset, (CharSequence)";");
            }
        }
    }
}

