/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.CodeBlockOrInitializerSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.List;

public class MethodOrClassSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiClass && !(e instanceof PsiTypeParameter) || e instanceof PsiMethod;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        int start;
        int i;
        List<TextRange> result = super.select(e, editorText, cursorOffset, editor);
        PsiElement firstChild = e.getFirstChild();
        PsiElement[] children = e.getChildren();
        if (firstChild instanceof PsiDocComment) {
            i = 1;
            while (children[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            TextRange range = new TextRange(children[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.addAll(MethodOrClassSelectioner.expandToWholeLine(editorText, range));
            range = new TextRange(firstChild.getTextRange().getStartOffset(), firstChild.getTextRange().getEndOffset());
            result.addAll(MethodOrClassSelectioner.expandToWholeLine(editorText, range));
        } else if (firstChild instanceof PsiComment) {
            i = 1;
            while (children[i] instanceof PsiComment || children[i] instanceof PsiWhiteSpace) {
                ++i;
            }
            PsiElement last = children[i - 1] instanceof PsiWhiteSpace ? children[i - 2] : children[i - 1];
            TextRange range = new TextRange(firstChild.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            if (range.contains(cursorOffset)) {
                result.addAll(MethodOrClassSelectioner.expandToWholeLine(editorText, range));
            }
            range = new TextRange(children[i].getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.addAll(MethodOrClassSelectioner.expandToWholeLine(editorText, range));
        }
        if (e instanceof PsiClass && (start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children)) != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
            result.addAll(MethodOrClassSelectioner.expandToWholeLine(editorText, new TextRange(start, end)));
        }
        return result;
    }
}

