/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class PrevNextParameterHandler
extends EditorActionHandler {
    private final boolean myIsNextParameterHandler;

    public PrevNextParameterHandler(boolean isNextParameterHandler) {
        this.myIsNextParameterHandler = isNextParameterHandler;
    }

    private static PsiElement getExpressionList(Editor editor, Project project) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        return ParameterInfoController.findArgumentList(file, offset, -1);
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement exprList = PrevNextParameterHandler.getExpressionList(editor, project);
        return exprList != null && ParameterInfoController.isAlreadyShown(editor, exprList.getTextRange().getStartOffset());
    }

    public void execute(Editor editor, DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        PsiElement exprList = PrevNextParameterHandler.getExpressionList(editor, project);
        int listOffset = exprList.getTextRange().getStartOffset();
        if (this.myIsNextParameterHandler) {
            ParameterInfoController.nextParameter(editor, listOffset);
        } else {
            ParameterInfoController.prevParameter(editor, listOffset);
        }
    }
}

