/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInstruction
extends Instruction {
    @Nullable
    private final PsiCallExpression myCall;
    @Nullable
    private PsiType myType;
    @NotNull
    private final PsiExpression[] myArgs;
    private boolean myShouldFlushFields;
    @NotNull
    private final PsiExpression myContext;
    private final MethodType myMethodType;

    public MethodCallInstruction(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction.<init> must not be null");
        }
        this((PsiExpression)callExpression, MethodType.REGULAR_METHOD_CALL);
    }

    public MethodCallInstruction(@NotNull PsiExpression context, MethodType methodType, PsiType resultType) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction.<init> must not be null");
        }
        this(context, methodType);
        this.myType = resultType;
        this.myShouldFlushFields = false;
    }

    public MethodCallInstruction(@NotNull PsiExpression context, MethodType methodType) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction.<init> must not be null");
        }
        this.myContext = context;
        this.myMethodType = methodType;
        this.myCall = context instanceof PsiCallExpression ? (PsiCallExpression)context : null;
        PsiExpressionList argList = this.myCall == null ? null : this.myCall.getArgumentList();
        this.myArgs = argList != null ? argList.getExpressions() : PsiExpression.EMPTY_ARRAY;
        this.myType = this.myCall == null ? null : this.myCall.getType();
        this.myShouldFlushFields = true;
        if (this.myCall instanceof PsiNewExpression && this.myType != null && this.myType.getArrayDimensions() > 0) {
            this.myShouldFlushFields = false;
        }
    }

    @Nullable
    public PsiType getResultType() {
        return this.myType;
    }

    @NotNull
    public PsiExpression[] getArgs() {
        if (this.myArgs == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction.getArgs must not return null");
        }
        return this.myArgs;
    }

    public MethodType getMethodType() {
        return this.myMethodType;
    }

    public boolean shouldFlushFields() {
        return this.myShouldFlushFields;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitMethodCall(this, runner, stateBefore);
    }

    @Nullable
    public PsiCallExpression getCallExpression() {
        return this.myCall;
    }

    @NotNull
    public PsiExpression getContext() {
        PsiExpression psiExpression = this.myContext;
        if (psiExpression == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction.getContext must not return null");
        }
        return psiExpression;
    }

    @Override
    public String toString() {
        return this.myMethodType == MethodType.UNBOXING ? "UNBOX" : (this.myMethodType == MethodType.BOXING ? "BOX" : "CALL_METHOD: " + this.myCall.getText());
    }

    public static enum MethodType {
        BOXING,
        UNBOXING,
        REGULAR_METHOD_CALL,
        CAST;

    }
}

