/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.InternalIterator;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="NodeRendererSettings", storages={@Storage(id="other", file="$APP_CONFIG$/debugger.renderers.xml")})
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String REFERENCE_RENDERER = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String RENDERER_ID = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> myDispatcher = EventDispatcher.create(NodeRendererSettingsListener.class);
    private final List<NodeRenderer> myPluginRenderers = new ArrayList<NodeRenderer>();
    private RendererConfiguration myCustomRenderers = new RendererConfiguration(this);
    private final PrimitiveRenderer myPrimitiveRenderer = new PrimitiveRenderer();
    private final ArrayRenderer myArrayRenderer = new ArrayRenderer();
    private final ClassRenderer myClassRenderer = new ClassRenderer();
    private final HexRenderer myHexRenderer = new HexRenderer();
    private final ToStringRenderer myToStringRenderer = new ToStringRenderer();
    private final NodeRenderer[] myAlternateCollectionRenderers = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), this.createExpressionChildrenRenderer("entrySet().toArray()", "!isEmpty()")), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", NodeRendererSettings.createLabelRenderer(null, "\" \" + getKey() + \" -> \" + getValue()", null), this.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.createLabelRenderer(" size = ", "size()", null), this.createExpressionChildrenRenderer("toArray()", "!isEmpty()"))};
    @NonNls
    private static final String HEX_VIEW_ENABLED = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String ALTERNATIVE_COLLECTION_VIEW_ENABLED = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String CUSTOM_RENDERERS_TAG_NAME = "CustomRenderers";

    public NodeRendererSettings() {
        this.myHexRenderer.setEnabled(false);
        this.myToStringRenderer.setEnabled(true);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ServiceManager.getService(NodeRendererSettings.class);
    }

    public void addPluginRenderer(NodeRenderer renderer) {
        this.myPluginRenderers.add(renderer);
    }

    public void removePluginRenderer(NodeRenderer renderer) {
        this.myPluginRenderers.remove(renderer);
    }

    public void setAlternateCollectionViewsEnabled(boolean enabled) {
        for (NodeRenderer myAlternateCollectionRenderer : this.myAlternateCollectionRenderers) {
            myAlternateCollectionRenderer.setEnabled(enabled);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.myAlternateCollectionRenderers[0].isEnabled();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeRendererSettings)) {
            return false;
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)o).getState());
    }

    public void addListener(NodeRendererSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(NodeRendererSettingsListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public Element getState() {
        Element element = new Element("NodeRendererSettings");
        JDOMExternalizerUtil.writeField((Element)element, (String)HEX_VIEW_ENABLED, (String)(this.myHexRenderer.isEnabled() ? "true" : "false"));
        JDOMExternalizerUtil.writeField((Element)element, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED, (String)(this.areAlternateCollectionViewsEnabled() ? "true" : "false"));
        try {
            element.addContent(this.writeRenderer(this.myArrayRenderer));
            element.addContent(this.writeRenderer(this.myToStringRenderer));
            element.addContent(this.writeRenderer(this.myClassRenderer));
            if (this.myCustomRenderers.getRendererCount() > 0) {
                Element custom = new Element(CUSTOM_RENDERERS_TAG_NAME);
                element.addContent(custom);
                this.myCustomRenderers.writeExternal(custom);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    public void loadState(Element root) {
        String alternativeEnabled;
        String hexEnabled = JDOMExternalizerUtil.readField((Element)root, (String)HEX_VIEW_ENABLED);
        if (hexEnabled != null) {
            this.myHexRenderer.setEnabled("true".equalsIgnoreCase(hexEnabled));
        }
        if ((alternativeEnabled = JDOMExternalizerUtil.readField((Element)root, (String)ALTERNATIVE_COLLECTION_VIEW_ENABLED)) != null) {
            this.setAlternateCollectionViewsEnabled("true".equalsIgnoreCase(alternativeEnabled));
        }
        List rendererElements = root.getChildren(RENDERER_TAG);
        for (Object rendererElement : rendererElements) {
            Element elem = (Element)rendererElement;
            String id = elem.getAttributeValue(RENDERER_ID);
            if (id == null) continue;
            try {
                if ("ArrayRenderer".equals(id)) {
                    this.myArrayRenderer.readExternal(elem);
                    continue;
                }
                if ("ToStringRenderer".equals(id)) {
                    this.myToStringRenderer.readExternal(elem);
                    continue;
                }
                if (!"ClassRenderer".equals(id)) continue;
                this.myClassRenderer.readExternal(elem);
            }
            catch (InvalidDataException e) {}
        }
        Element custom = root.getChild(CUSTOM_RENDERERS_TAG_NAME);
        if (custom != null) {
            this.myCustomRenderers.readExternal(custom);
        }
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.myCustomRenderers;
    }

    public void setCustomRenderers(@NotNull RendererConfiguration customRenderers) {
        if (customRenderers == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/settings/NodeRendererSettings.setCustomRenderers must not be null");
        }
        RendererConfiguration oldConfig = this.myCustomRenderers;
        this.myCustomRenderers = customRenderers;
        if (oldConfig == null || !oldConfig.equals(customRenderers)) {
            this.fireRenderersChanged();
        }
    }

    public List<NodeRenderer> getPluginRenderers() {
        return new ArrayList<NodeRenderer>(this.myPluginRenderers);
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.myPrimitiveRenderer;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.myArrayRenderer;
    }

    public ClassRenderer getClassRenderer() {
        return this.myClassRenderer;
    }

    public HexRenderer getHexRenderer() {
        return this.myHexRenderer;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.myToStringRenderer;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.myAlternateCollectionRenderers;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.myDispatcher.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers() {
        final ArrayList<NodeRenderer> allRenderers = new ArrayList<NodeRenderer>();
        allRenderers.add(this.myHexRenderer);
        allRenderers.add(this.myPrimitiveRenderer);
        allRenderers.addAll(this.myPluginRenderers);
        this.myCustomRenderers.iterateRenderers(new InternalIterator<NodeRenderer>(){

            public boolean visit(NodeRenderer renderer) {
                allRenderers.add(renderer);
                return true;
            }
        });
        for (NodeRenderer myAlternateCollectionRenderer : this.myAlternateCollectionRenderers) {
            allRenderers.add(myAlternateCollectionRenderer);
        }
        allRenderers.add(this.myToStringRenderer);
        allRenderers.add(this.myArrayRenderer);
        allRenderers.add(this.myClassRenderer);
        return allRenderers;
    }

    public boolean isBase(Renderer renderer) {
        return renderer == this.myPrimitiveRenderer || renderer == this.myArrayRenderer || renderer == this.myClassRenderer;
    }

    public Renderer readRenderer(Element root) throws InvalidDataException {
        if (root == null) {
            return null;
        }
        if (!RENDERER_TAG.equals(root.getName())) {
            throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
        }
        String rendererId = root.getAttributeValue(RENDERER_ID);
        if (rendererId == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        Renderer renderer = this.createRenderer(rendererId);
        if (renderer == null) {
            throw new InvalidDataException("unknown renderer ID: " + rendererId);
        }
        renderer.readExternal(root);
        return renderer;
    }

    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        Element root = new Element(RENDERER_TAG);
        if (renderer != null) {
            root.setAttribute(RENDERER_ID, renderer.getUniqueId());
            renderer.writeExternal(root);
        }
        return root;
    }

    public Renderer createRenderer(String rendererId) {
        if ("ClassRenderer".equals(rendererId)) {
            return this.myClassRenderer;
        }
        if ("ArrayRenderer".equals(rendererId)) {
            return this.myArrayRenderer;
        }
        if ("PrimitiveRenderer".equals(rendererId)) {
            return this.myPrimitiveRenderer;
        }
        if ("HexRenderer".equals(rendererId)) {
            return this.myHexRenderer;
        }
        if (rendererId.equals("ExpressionChildrenRenderer")) {
            return new ExpressionChildrenRenderer();
        }
        if (rendererId.equals("LabelRenderer")) {
            return new LabelRenderer();
        }
        if (rendererId.equals("EnumerationChildrenRenderer")) {
            return new EnumerationChildrenRenderer();
        }
        if (rendererId.equals("ToStringRenderer")) {
            return this.myToStringRenderer;
        }
        if (rendererId.equals("CompoundNodeRenderer") || rendererId.equals(REFERENCE_RENDERER)) {
            return this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
        }
        return null;
    }

    private CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String rendererName, @NonNls String className, LabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer renderer = new CompoundReferenceRenderer(this, rendererName, labelRenderer, childrenRenderer);
        renderer.setClassName(className);
        return renderer;
    }

    private ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String expressionText, @NonNls String childrenExpandableText) {
        ExpressionChildrenRenderer childrenRenderer = new ExpressionChildrenRenderer();
        childrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText));
        if (childrenExpandableText != null) {
            childrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, childrenExpandableText));
        }
        return childrenRenderer;
    }

    private EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] expressions) {
        EnumerationChildrenRenderer childrenRenderer = new EnumerationChildrenRenderer();
        if (expressions != null && expressions.length > 0) {
            ArrayList<Pair<String, TextWithImports>> childrenList = new ArrayList<Pair<String, TextWithImports>>(expressions.length);
            for (String[] expression : expressions) {
                childrenList.add((Pair<String, TextWithImports>)new Pair((Object)expression[0], (Object)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression[1])));
            }
            childrenRenderer.setChildren(childrenList);
        }
        return childrenRenderer;
    }

    private static LabelRenderer createLabelRenderer(final @NonNls String prefix, @NonNls String expressionText, final @NonNls String postfix) {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                String evaluated = super.calcLabel(descriptor, evaluationContext, labelListener);
                if (prefix == null && postfix == null) {
                    return evaluated;
                }
                if (prefix != null && postfix != null) {
                    return prefix + evaluated + postfix;
                }
                if (prefix != null) {
                    return prefix + evaluated;
                }
                return evaluated + postfix;
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText));
        return labelRenderer;
    }
}

