/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.Presentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/actions/RunContextAction.<init> must not be null");
        }
        super(ExecutionBundle.message((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), null, executor.getIcon());
        this.myExecutor = executor;
    }

    @Override
    protected void perform(ConfigurationContext context) {
        RunnerAndConfigurationSettingsImpl configuration = context.findExisting();
        RunManagerEx runManager = context.getRunManager();
        if (configuration == null) {
            configuration = context.getConfiguration();
            if (configuration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration);
        }
        runManager.setActiveConfiguration(configuration);
        ExecutionUtil.executeConfiguration(context.getProject(), configuration, this.myExecutor);
    }

    @Override
    protected boolean isEnabledFor(RunConfiguration configuration) {
        return this.getRunner(configuration) != null;
    }

    @Nullable
    private ProgramRunner getRunner(RunConfiguration configuration) {
        return RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)configuration);
    }

    @Override
    protected void updatePresentation(Presentation presentation, String actionText, ConfigurationContext context) {
        presentation.setText(this.myExecutor.getStartActionText() + actionText, true);
        RunnerAndConfigurationSettingsImpl configuration = context.findExisting();
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        boolean b = configuration != null && this.getRunner(configuration.getConfiguration()) != null;
        presentation.setEnabled(b);
        presentation.setVisible(b);
    }
}

