/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerNodeDescriptor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;

public class TestTreeRenderer
extends ColoredTreeCellRenderer {
    private final TestConsoleProperties myConsoleProperties;
    @NonNls
    private static final String SPACE_STRING = " ";

    public TestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof SMTRunnerNodeDescriptor) {
            SMTRunnerNodeDescriptor desc = (SMTRunnerNodeDescriptor)((Object)userObj);
            SMTestProxy testProxy = desc.getElement();
            if (node == tree.getModel().getRoot()) {
                if (node.isLeaf()) {
                    TestsPresentationUtil.formatRootNodeWithoutChildren(testProxy, this);
                } else {
                    TestsPresentationUtil.formatRootNodeWithChildren(testProxy, this);
                }
            } else {
                TestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }
}

