/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryDownloader;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadingMirrorsMap;
import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCompositionSettings {
    @NonNls
    private static final String DEFAULT_LIB_FOLDER = "lib";
    private final LibraryInfo[] myLibraryInfos;
    private final String myBaseDirectoryForDownloadedFiles;
    private final String myTitle;
    private String myDirectoryForDownloadedLibrariesPath;
    private final Set<VirtualFile> myAddedJars;
    private boolean myDownloadLibraries;
    private final Set<Library> myUsedLibraries;
    private LibrariesContainer.LibraryLevel myLibraryLevel;
    private String myLibraryName;
    private final Icon myIcon;

    public LibraryCompositionSettings(@NotNull LibraryInfo[] libraryInfos, @NotNull String defaultLibraryName, @NotNull String baseDirectoryForDownloadedFiles, String title, @Nullable Icon icon) {
        if (libraryInfos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.<init> must not be null");
        }
        if (defaultLibraryName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.<init> must not be null");
        }
        if (baseDirectoryForDownloadedFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.<init> must not be null");
        }
        this.myAddedJars = new LinkedHashSet<VirtualFile>();
        this.myDownloadLibraries = true;
        this.myUsedLibraries = new LinkedHashSet<Library>();
        this.myLibraryLevel = LibrariesContainer.LibraryLevel.PROJECT;
        this.myLibraryInfos = libraryInfos;
        this.myBaseDirectoryForDownloadedFiles = baseDirectoryForDownloadedFiles;
        this.myTitle = title;
        this.myLibraryName = defaultLibraryName;
        this.myIcon = icon;
    }

    @NotNull
    public LibraryInfo[] getLibraryInfos() {
        if (this.myLibraryInfos == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.getLibraryInfos must not return null");
        }
        return this.myLibraryInfos;
    }

    @NotNull
    public String getBaseDirectoryForDownloadedFiles() {
        String string = this.myBaseDirectoryForDownloadedFiles;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.getBaseDirectoryForDownloadedFiles must not return null");
        }
        return string;
    }

    public void setDirectoryForDownloadedLibrariesPath(String directoryForDownloadedLibrariesPath) {
        this.myDirectoryForDownloadedLibrariesPath = directoryForDownloadedLibrariesPath;
    }

    public Set<VirtualFile> getAddedJars() {
        return this.myAddedJars;
    }

    public void setAddedJars(Collection<VirtualFile> addedJars) {
        this.myAddedJars.clear();
        this.myAddedJars.addAll(addedJars);
    }

    public boolean isDownloadLibraries() {
        return this.myDownloadLibraries;
    }

    public void setDownloadLibraries(boolean downloadLibraries) {
        this.myDownloadLibraries = downloadLibraries;
    }

    public void setUsedLibraries(Collection<Library> addedLibraries) {
        this.myUsedLibraries.clear();
        this.myUsedLibraries.addAll(addedLibraries);
    }

    public void setLibraryLevel(LibrariesContainer.LibraryLevel libraryLevel) {
        this.myLibraryLevel = libraryLevel;
    }

    public void setLibraryName(String libraryName) {
        this.myLibraryName = libraryName;
    }

    public String getDirectoryForDownloadedLibrariesPath() {
        if (this.myDirectoryForDownloadedLibrariesPath == null) {
            this.myDirectoryForDownloadedLibrariesPath = this.myBaseDirectoryForDownloadedFiles + "/" + DEFAULT_LIB_FOLDER;
        }
        return this.myDirectoryForDownloadedLibrariesPath;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public boolean downloadFiles(@NotNull LibraryDownloadingMirrorsMap mirrorsMap, @NotNull LibrariesContainer librariesContainer, @NotNull JComponent parent, boolean all) {
        if (mirrorsMap == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.downloadFiles must not be null");
        }
        if (librariesContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.downloadFiles must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.downloadFiles must not be null");
        }
        if (this.myDownloadLibraries) {
            LibraryDownloadInfo[] downloadingInfos;
            RequiredLibrariesInfo requiredLibraries = new RequiredLibrariesInfo(this.getLibraryInfos());
            ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
            roots.addAll(this.myAddedJars);
            for (Library library : this.myUsedLibraries) {
                roots.addAll(Arrays.asList(librariesContainer.getLibraryFiles(library, OrderRootType.CLASSES)));
            }
            VirtualFile[] jars = VfsUtil.toVirtualFileArray(roots);
            RequiredLibrariesInfo.RequiredClassesNotFoundInfo info = requiredLibraries.checkLibraries(jars, all);
            if (info != null && (downloadingInfos = LibraryDownloader.getDownloadingInfos(info.getLibraryInfos())).length > 0) {
                LibraryDownloader downloader = new LibraryDownloader(downloadingInfos, null, parent, this.getDirectoryForDownloadedLibrariesPath(), this.myLibraryName, mirrorsMap);
                VirtualFile[] files = downloader.download();
                if (files.length != downloadingInfos.length) {
                    return false;
                }
                this.myAddedJars.addAll(Arrays.asList(files));
            }
        }
        return true;
    }

    @Nullable
    private Library createLibrary(ModifiableRootModel rootModel, @Nullable LibrariesContainer additionalContainer) {
        if (!this.myAddedJars.isEmpty()) {
            VirtualFile[] roots = VfsUtil.toVirtualFileArray(this.myAddedJars);
            return LibrariesContainerFactory.createLibrary(additionalContainer, LibrariesContainerFactory.createContainer(rootModel), this.myLibraryName, this.myLibraryLevel, roots, VirtualFile.EMPTY_ARRAY);
        }
        return null;
    }

    public LibrariesContainer.LibraryLevel getLibraryLevel() {
        return this.myLibraryLevel;
    }

    public String getLibraryName() {
        return this.myLibraryName;
    }

    public Collection<Library> getUsedLibraries() {
        return Collections.unmodifiableCollection(this.myUsedLibraries);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Library addLibraries(ModifiableRootModel rootModel, List<Library> addedLibraries) {
        return this.addLibraries(rootModel, addedLibraries, null);
    }

    @Nullable
    public Library addLibraries(@NotNull ModifiableRootModel rootModel, @NotNull List<Library> addedLibraries, @Nullable LibrariesContainer librariesContainer) {
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.addLibraries must not be null");
        }
        if (addedLibraries == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionSettings.addLibraries must not be null");
        }
        Library library = this.createLibrary(rootModel, librariesContainer);
        if (library != null) {
            addedLibraries.add(library);
            if (this.getLibraryLevel() != LibrariesContainer.LibraryLevel.MODULE) {
                rootModel.addLibraryEntry(library);
            }
        }
        for (Library usedLibrary : this.getUsedLibraries()) {
            addedLibraries.add(usedLibrary);
            rootModel.addLibraryEntry(usedLibrary);
        }
        return library;
    }
}

