/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesManager
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findParameterUsages.FindUsagesManager");
    private static final Key<String> KEY_START_USAGE_AGAIN = Key.create((String)"KEY_START_USAGE_AGAIN");
    @NonNls
    private static final String VALUE_START_USAGE_AGAIN = "START_AGAIN";
    private final Project myProject;
    private final UsageViewManager myAnotherManager;
    private boolean myToOpenInNewTab = false;
    private final List<FindUsagesHandlerFactory> myHandlers = new ArrayList<FindUsagesHandlerFactory>();
    private SearchData myLastSearchInFileData = new SearchData();
    private final CopyOnWriteArrayList<SearchData> myFindUsagesHistory = ContainerUtil.createEmptyCOWList();

    public FindUsagesManager(Project project, UsageViewManager anotherManager) {
        this.myProject = project;
        this.myAnotherManager = anotherManager;
    }

    public void registerFindUsagesHandler(FindUsagesHandlerFactory handler) {
        this.myHandlers.add(0, handler);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.canFindUsages must not be null");
        }
        for (FindUsagesHandlerFactory factory : this.myHandlers) {
            if (!factory.canFindUsages(element)) continue;
            return true;
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            return true;
        }
        return false;
    }

    public void clearFindingNextUsageInFile() {
        this.myLastSearchInFileData.myOptions = null;
        this.myLastSearchInFileData.myElements = null;
    }

    public boolean findNextUsageInFile(FileEditor editor) {
        return this.findUsageInFile(editor, FileSearchScope.AFTER_CARET);
    }

    public boolean findPreviousUsageInFile(FileEditor editor) {
        return this.findUsageInFile(editor, FileSearchScope.BEFORE_CARET);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myToOpenInNewTab = JDOMExternalizer.readBoolean((Element)element, (String)"OPEN_NEW_TAB");
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizer.write((Element)element, (String)"OPEN_NEW_TAB", (boolean)this.myToOpenInNewTab);
    }

    private boolean findUsageInFile(@NotNull FileEditor editor, FileSearchScope direction) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findUsageInFile must not be null");
        }
        PsiElement[] elements = this.restorePsiElements(this.myLastSearchInFileData, true);
        if (elements == null) {
            return false;
        }
        if (elements.length == 0) {
            return true;
        }
        UsageInfoToUsageConverter.TargetElementsDescriptor descriptor = new UsageInfoToUsageConverter.TargetElementsDescriptor(elements);
        TextEditor textEditor = (TextEditor)editor;
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FindUsagesHandler handler = this.getFindUsagesHandler(elements[0], false);
        if (handler == null) {
            return false;
        }
        this.findUsagesInEditor(descriptor, handler, psiFile, direction, this.myLastSearchInFileData.myOptions, (FileEditor)textEditor);
        return true;
    }

    @Nullable
    private PsiElement[] restorePsiElements(SearchData searchData, boolean showErrorMessage) {
        if (searchData == null) {
            return null;
        }
        SmartPsiElementPointer[] lastSearchElements = searchData.myElements;
        if (lastSearchElements == null) {
            return null;
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer pointer : lastSearchElements) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            elements.add(element);
        }
        if (elements.isEmpty() && showErrorMessage) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.searched.elements.have.been.changed.error", new Object[0]), (String)FindBundle.message("cannot.search.for.usages.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return PsiElement.EMPTY_ARRAY;
        }
        return elements.toArray(new PsiElement[elements.size()]);
    }

    private void initLastSearchElement(FindUsagesOptions findUsagesOptions, UsageInfoToUsageConverter.TargetElementsDescriptor descriptor) {
        this.myLastSearchInFileData = this.createSearchData(descriptor.getAllElements(), findUsagesOptions);
    }

    private SearchData createSearchData(List<? extends PsiElement> psiElements, FindUsagesOptions findUsagesOptions) {
        SearchData data = new SearchData();
        data.myElements = new SmartPsiElementPointer[psiElements.size()];
        int idx = 0;
        for (PsiElement psiElement : psiElements) {
            data.myElements[idx++] = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(psiElement);
        }
        data.myOptions = findUsagesOptions;
        return data;
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(PsiElement element, boolean forHighlightUsages) {
        for (FindUsagesHandlerFactory factory : this.myHandlers) {
            if (!factory.canFindUsages(element)) continue;
            FindUsagesHandler handler = factory.createFindUsagesHandler(element, forHighlightUsages);
            if (handler == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler == null) continue;
            return handler;
        }
        for (FindUsagesHandlerFactory factory : (FindUsagesHandlerFactory[])Extensions.getExtensions(FindUsagesHandlerFactory.EP_NAME, (AreaInstance)this.myProject)) {
            if (!factory.canFindUsages(element)) continue;
            FindUsagesHandler handler = factory.createFindUsagesHandler(element, forHighlightUsages);
            if (handler == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public void findUsages(@NotNull PsiElement psiElement, PsiFile scopeFile, FileEditor editor) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findUsages must not be null");
        }
        FindUsagesHandler handler = this.getFindUsagesHandler(psiElement, false);
        if (handler == null) {
            return;
        }
        boolean singleFile = scopeFile != null;
        AbstractFindUsagesDialog dialog = handler.getFindUsagesDialog(singleFile, this.shouldOpenInNewTab(), this.mustOpenInNewTab());
        if (!singleFile) {
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
        }
        this.setOpenInNewTab(dialog.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = dialog.calcFindUsagesOptions();
        this.clearFindingNextUsageInFile();
        LOG.assertTrue(handler.getPsiElement().isValid());
        UsageInfoToUsageConverter.TargetElementsDescriptor descriptor = new UsageInfoToUsageConverter.TargetElementsDescriptor(handler.getPrimaryElements(), handler.getSecondaryElements());
        if (singleFile) {
            findUsagesOptions = (FindUsagesOptions)findUsagesOptions.clone();
            findUsagesOptions.isDerivedClasses = false;
            findUsagesOptions.isDerivedInterfaces = false;
            findUsagesOptions.isImplementingClasses = false;
            editor.putUserData(KEY_START_USAGE_AGAIN, null);
            this.findUsagesInEditor(descriptor, handler, scopeFile, FileSearchScope.FROM_START, findUsagesOptions, editor);
        } else {
            this.findUsages(descriptor, handler, dialog.isSkipResultsWhenOneUsage(), dialog.isShowInSeparateWindow(), findUsagesOptions);
        }
    }

    @Nullable
    public static SearchScope getCurrentSearchScope(FindUsagesHandler handler) {
        if (handler == null) {
            return null;
        }
        FindUsagesOptions findUsagesOptions = handler.getFindUsagesOptions();
        return findUsagesOptions.searchScope;
    }

    @Nullable
    public UsageViewPresentation processUsages(FindUsagesHandler handler, final @NotNull Processor<Usage> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.processUsages must not be null");
        }
        if (handler == null) {
            return null;
        }
        FindUsagesOptions findUsagesOptions = handler.getFindUsagesOptions();
        PsiElement element = handler.getPsiElement();
        LOG.assertTrue(element.isValid());
        UsageInfoToUsageConverter.TargetElementsDescriptor descriptor = new UsageInfoToUsageConverter.TargetElementsDescriptor(handler.getPrimaryElements(), handler.getSecondaryElements());
        UsageViewPresentation presentation = FindUsagesManager.createPresentation(element, findUsagesOptions, this.myToOpenInNewTab);
        final UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(descriptor, handler, findUsagesOptions, null);
        final boolean[] canceled = new boolean[]{false};
        final AtomicInteger usageCount = new AtomicInteger();
        Task.Modal task = new Task.Modal(this.myProject, UsageViewManagerImpl.getProgressTitle((UsageViewPresentation)presentation), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager$1.run must not be null");
                }
                usageSearcher.generate((Processor)new Processor<Usage>(){

                    public boolean process(Usage usage) {
                        usageCount.incrementAndGet();
                        return processor.process((Object)usage);
                    }
                });
            }

            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                return new Task.NotificationInfo("Find Usages", "Find Usages Finished", usageCount.get() + " Usage(s) Found");
            }

            public void onCancel() {
                canceled[0] = true;
            }
        };
        ProgressManager.getInstance().run((Task)task);
        if (canceled[0]) {
            return null;
        }
        return presentation;
    }

    private void setOpenInNewTab(boolean toOpenInNewTab) {
        if (!this.mustOpenInNewTab()) {
            this.myToOpenInNewTab = toOpenInNewTab;
        }
    }

    private boolean shouldOpenInNewTab() {
        return this.mustOpenInNewTab() || this.myToOpenInNewTab;
    }

    private boolean mustOpenInNewTab() {
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        return selectedContent != null && selectedContent.isPinned();
    }

    private static UsageSearcher createUsageSearcher(final UsageInfoToUsageConverter.TargetElementsDescriptor descriptor, final FindUsagesHandler handler, final FindUsagesOptions options, final PsiFile scopeFile) {
        return new UsageSearcher(){

            public void generate(final @NotNull Processor<Usage> processor) {
                if (processor == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager$2.generate must not be null");
                }
                if (scopeFile != null) {
                    options.searchScope = new LocalSearchScope((PsiElement)scopeFile);
                }
                Processor<UsageInfo> usageInfoProcessorToUsageProcessorAdapter = new Processor<UsageInfo>(){

                    public boolean process(UsageInfo usageInfo) {
                        return processor.process((Object)UsageInfoToUsageConverter.convert((UsageInfoToUsageConverter.TargetElementsDescriptor)descriptor, (UsageInfo)usageInfo));
                    }
                };
                List elements = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<? extends PsiElement>>(){

                    public List<? extends PsiElement> compute() {
                        return descriptor.getAllElements();
                    }
                });
                for (final PsiElement element : elements) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            LOG.assertTrue(element.isValid());
                        }
                    });
                    handler.processElementUsages(element, usageInfoProcessorToUsageProcessorAdapter, options);
                }
            }
        };
    }

    private static PsiElement2UsageTargetAdapter[] convertToUsageTargets(List<? extends PsiElement> elementsToSearch) {
        ArrayList<PsiElement2UsageTargetAdapter> targets = new ArrayList<PsiElement2UsageTargetAdapter>(elementsToSearch.size());
        for (PsiElement psiElement : elementsToSearch) {
            FindUsagesManager.convertToUsageTarget(targets, psiElement);
        }
        return targets.toArray(new PsiElement2UsageTargetAdapter[targets.size()]);
    }

    private void findUsages(final UsageInfoToUsageConverter.TargetElementsDescriptor descriptor, final FindUsagesHandler handler, boolean toSkipUsagePanelWhenOneUsage, boolean toOpenInNewTab, final FindUsagesOptions findUsagesOptions) {
        List elements = descriptor.getAllElements();
        PsiElement2UsageTargetAdapter[] targets = FindUsagesManager.convertToUsageTargets(elements);
        this.myAnotherManager.searchAndShowUsages((UsageTarget[])targets, (Factory)new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return FindUsagesManager.createUsageSearcher(descriptor, handler, findUsagesOptions, null);
            }
        }, !toSkipUsagePanelWhenOneUsage, true, FindUsagesManager.createPresentation((PsiElement)elements.get(0), findUsagesOptions, toOpenInNewTab), null);
        this.addToHistory(elements, findUsagesOptions);
    }

    private static UsageViewPresentation createPresentation(PsiElement psiElement, FindUsagesOptions findUsagesOptions, boolean toOpenInNewTab) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scopeString = findUsagesOptions.searchScope != null ? findUsagesOptions.searchScope.getDisplayName() : null;
        presentation.setScopeText(scopeString);
        String usagesString = FindUsagesManager.generateUsagesString(findUsagesOptions);
        presentation.setUsagesString(usagesString);
        String title = scopeString != null ? FindBundle.message("find.usages.of.element.in.scope.panel.title", usagesString, UsageViewUtil.getLongName(psiElement), scopeString) : FindBundle.message("find.usages.of.element.panel.title", usagesString, UsageViewUtil.getLongName(psiElement));
        presentation.setTabText(title);
        presentation.setTabName(FindBundle.message("find.usages.of.element.tab.name", usagesString, UsageViewUtil.getShortName(psiElement)));
        presentation.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)));
        presentation.setOpenInNewTab(toOpenInNewTab);
        return presentation;
    }

    private void findUsagesInEditor(UsageInfoToUsageConverter.TargetElementsDescriptor descriptor, FindUsagesHandler handler, PsiFile scopeFile, FileSearchScope direction, FindUsagesOptions findUsagesOptions, @NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findUsagesInEditor must not be null");
        }
        this.initLastSearchElement(findUsagesOptions, descriptor);
        this.clearStatusBar();
        FileEditorLocation currentLocation = fileEditor.getCurrentLocation();
        UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(descriptor, handler, findUsagesOptions, scopeFile);
        boolean[] usagesWereFound = new boolean[]{false};
        Usage fUsage = FindUsagesManager.findSiblingUsage(this.myProject, usageSearcher, direction, currentLocation, usagesWereFound, fileEditor);
        if (fUsage != null) {
            fUsage.navigate(true);
            fUsage.selectInEditor();
        } else if (!usagesWereFound[0]) {
            String message = FindUsagesManager.getNoUsagesFoundMessage(descriptor.getPrimaryElements()[0]) + " in " + scopeFile.getName();
            this.showHintOrStatusBarMessage(message, fileEditor);
        } else {
            fileEditor.putUserData(KEY_START_USAGE_AGAIN, (Object)VALUE_START_USAGE_AGAIN);
            this.showHintOrStatusBarMessage(FindUsagesManager.getSearchAgainMessage(descriptor.getPrimaryElements()[0], direction), fileEditor);
        }
    }

    private static String getNoUsagesFoundMessage(PsiElement psiElement) {
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        return FindBundle.message("find.usages.of.element_type.element_name.not.found.message", elementType, elementName);
    }

    private void clearStatusBar() {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        statusBar.setInfo("");
    }

    private static String getSearchAgainMessage(PsiElement element, FileSearchScope direction) {
        String shortcutsText;
        AnAction action;
        String shortcutsText2;
        String message = FindUsagesManager.getNoUsagesFoundMessage(element);
        message = direction == FileSearchScope.AFTER_CARET ? ((shortcutsText2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action = ActionManager.getInstance().getAction("FindNext")))).length() > 0 ? FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText2) : FindBundle.message("find.search.again.from.top.action.message", message)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FindPrevious"))).length() > 0 ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message));
        return message;
    }

    private void showHintOrStatusBarMessage(String message, FileEditor fileEditor) {
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            FindUsagesManager.showEditorHint(message, textEditor.getEditor());
        } else {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
            statusBar.setInfo(message);
        }
    }

    private static Usage findSiblingUsage(@NotNull Project project, @NotNull UsageSearcher usageSearcher, FileSearchScope dir, final FileEditorLocation currentLocation, final @NotNull boolean[] usagesWereFound, @NotNull FileEditor fileEditor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findSiblingUsage must not be null");
        }
        if (usageSearcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findSiblingUsage must not be null");
        }
        if (usagesWereFound == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findSiblingUsage must not be null");
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.findSiblingUsage must not be null");
        }
        if (fileEditor.getUserData(KEY_START_USAGE_AGAIN) != null) {
            dir = dir == FileSearchScope.AFTER_CARET ? FileSearchScope.FROM_START : FileSearchScope.FROM_END;
        }
        final FileSearchScope direction = dir;
        final UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
        usageViewManager.setCurrentSearchCancelled(false);
        final Usage[] foundUsage = new Usage[]{null};
        usageSearcher.generate((Processor)new Processor<Usage>(){

            public boolean process(Usage usage) {
                if (usageViewManager.searchHasBeenCancelled()) {
                    return false;
                }
                usagesWereFound[0] = true;
                if (direction == FileSearchScope.FROM_START) {
                    foundUsage[0] = usage;
                    return false;
                }
                if (direction == FileSearchScope.FROM_END) {
                    foundUsage[0] = usage;
                } else if (direction == FileSearchScope.AFTER_CARET) {
                    if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) > 0) {
                        foundUsage[0] = usage;
                        return false;
                    }
                } else if (direction == FileSearchScope.BEFORE_CARET) {
                    if (Comparing.compare((Comparable)usage.getLocation(), (Comparable)currentLocation) < 0) {
                        if (foundUsage[0] != null) {
                            if (foundUsage[0].getLocation().compareTo((Object)usage.getLocation()) < 0) {
                                foundUsage[0] = usage;
                            }
                        } else {
                            foundUsage[0] = usage;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
        });
        fileEditor.putUserData(KEY_START_USAGE_AGAIN, null);
        return foundUsage[0];
    }

    private static void convertToUsageTarget(@NotNull List<PsiElement2UsageTargetAdapter> targets, @NotNull PsiElement elementToSearch) {
        if (targets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.convertToUsageTarget must not be null");
        }
        if (elementToSearch == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/findUsages/FindUsagesManager.convertToUsageTarget must not be null");
        }
        if (!(elementToSearch instanceof NavigationItem)) {
            throw new IllegalArgumentException("Wrong usage target:" + elementToSearch + "; " + elementToSearch.getClass());
        }
        targets.add(new PsiElement2UsageTargetAdapter(elementToSearch));
    }

    private static String generateUsagesString(FindUsagesOptions selectedOptions) {
        String suffix = " " + FindBundle.message("find.usages.panel.title.separator", new Object[0]) + " ";
        ArrayList<String> strings = new ArrayList<String>();
        if (selectedOptions.isUsages || selectedOptions.isClassesUsages || selectedOptions.isMethodsUsages || selectedOptions.isFieldsUsages) {
            strings.add(FindBundle.message("find.usages.panel.title.usages", new Object[0]));
        }
        if (selectedOptions.isIncludeOverloadUsages) {
            strings.add(FindBundle.message("find.usages.panel.title.overloaded.methods.usages", new Object[0]));
        }
        if (selectedOptions.isDerivedClasses) {
            strings.add(FindBundle.message("find.usages.panel.title.derived.classes", new Object[0]));
        }
        if (selectedOptions.isDerivedInterfaces) {
            strings.add(FindBundle.message("find.usages.panel.title.derived.interfaces", new Object[0]));
        }
        if (selectedOptions.isImplementingClasses) {
            strings.add(FindBundle.message("find.usages.panel.title.implementing.classes", new Object[0]));
        }
        if (selectedOptions.isImplementingMethods) {
            strings.add(FindBundle.message("find.usages.panel.title.implementing.methods", new Object[0]));
        }
        if (selectedOptions.isOverridingMethods) {
            strings.add(FindBundle.message("find.usages.panel.title.overriding.methods", new Object[0]));
        }
        if (strings.isEmpty()) {
            strings.add(FindBundle.message("find.usages.panel.title.usages", new Object[0]));
        }
        String usagesString = "";
        for (int i = 0; i < strings.size(); ++i) {
            String s = (String)strings.get(i);
            usagesString = usagesString + (i == strings.size() - 1 ? s : s + suffix);
        }
        return usagesString;
    }

    private static void showEditorHint(String message, Editor editor) {
        JLabel component = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    public static String getHelpID(PsiElement element) {
        return ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(element.getLanguage())).getHelpId(element);
    }

    private void addToHistory(List<? extends PsiElement> elements, FindUsagesOptions findUsagesOptions) {
        SearchData data = this.createSearchData(elements, findUsagesOptions);
        this.myFindUsagesHistory.remove(data);
        this.myFindUsagesHistory.add(data);
        if (this.myFindUsagesHistory.size() > 15) {
            this.myFindUsagesHistory.remove(0);
        }
    }

    public void rerunAndRecallFromHistory(SearchData searchData) {
        this.myFindUsagesHistory.remove(searchData);
        PsiElement[] elements = this.restorePsiElements(searchData, true);
        if (elements == null || elements.length == 0) {
            return;
        }
        UsageInfoToUsageConverter.TargetElementsDescriptor descriptor = new UsageInfoToUsageConverter.TargetElementsDescriptor(elements);
        FindUsagesHandler handler = this.getFindUsagesHandler(elements[0], false);
        if (handler == null) {
            return;
        }
        this.findUsages(descriptor, handler, false, false, searchData.myOptions);
    }

    public List<SearchData> getFindUsageHistory() {
        this.removeInvalidElementsFromHistory();
        return Collections.unmodifiableList(this.myFindUsagesHistory);
    }

    private void removeInvalidElementsFromHistory() {
        for (SearchData data : this.myFindUsagesHistory) {
            PsiElement[] elements = this.restorePsiElements(data, false);
            if (elements != null && elements.length != 0) continue;
            this.myFindUsagesHistory.remove(data);
        }
    }

    public static class SearchData {
        public SmartPsiElementPointer[] myElements = null;
        public FindUsagesOptions myOptions = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchData that = (SearchData)o;
            if (!Arrays.equals(this.myElements, that.myElements)) {
                return false;
            }
            return !(this.myOptions != null ? !this.myOptions.equals(that.myOptions) : that.myOptions != null);
        }

        public int hashCode() {
            return this.myElements != null ? Arrays.hashCode(this.myElements) : 0;
        }
    }

    private static enum FileSearchScope {
        FROM_START,
        FROM_END,
        AFTER_CARET,
        BEFORE_CARET;

    }
}

