/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;

public class FormatTextRanges {
    private List<FormatTextRange> myRanges = new ArrayList<FormatTextRange>();

    public FormatTextRanges() {
    }

    public FormatTextRanges(TextRange range, boolean processHeadingWhitespace) {
        this.add(range, processHeadingWhitespace);
    }

    public void add(TextRange range, boolean processHeadingWhitespace) {
        this.myRanges.add(new FormatTextRange(range, processHeadingWhitespace));
    }

    public boolean isWhitespaceReadOnly(TextRange range) {
        for (FormatTextRange formatTextRange : this.myRanges) {
            if (formatTextRange.isWhitespaceReadOnly(range)) continue;
            return false;
        }
        return true;
    }

    public boolean isReadOnly(TextRange range, boolean rootIsRightBlock) {
        for (FormatTextRange formatTextRange : this.myRanges) {
            if (formatTextRange.isReadOnly(range, rootIsRightBlock)) continue;
            return false;
        }
        return true;
    }

    public void preprocess(ASTNode fileNode) {
        for (FormatTextRange range : this.myRanges) {
            TextRange result = range.getTextRange();
            for (PreFormatProcessor processor : (PreFormatProcessor[])Extensions.getExtensions(PreFormatProcessor.EP_NAME)) {
                result = processor.process(fileNode, result);
            }
            range.setTextRange(result);
        }
    }

    public List<FormatTextRange> getRanges() {
        return this.myRanges;
    }

    public FormatTextRanges ensureNonEmpty() {
        FormatTextRanges result = new FormatTextRanges();
        for (FormatTextRange range : this.myRanges) {
            if (range.myProcessHeadingWhitespace) {
                result.add(range.getNonEmptyTextRange(), true);
                continue;
            }
            result.add(range.getTextRange(), false);
        }
        return result;
    }

    public String toString() {
        return "FormatTextRanges{" + StringUtil.join(this.myRanges, (Function)new Function<FormatTextRange, String>(){

            public String fun(FormatTextRange formatTextRange) {
                return formatTextRange.toString();
            }
        }, (String)",");
    }

    public static class FormatTextRange {
        private TextRange myRange;
        private boolean myProcessHeadingWhitespace;

        public FormatTextRange(TextRange range, boolean processHeadingWhitespace) {
            this.myRange = range;
            this.myProcessHeadingWhitespace = processHeadingWhitespace;
        }

        public boolean isWhitespaceReadOnly(TextRange range) {
            if (range.getStartOffset() >= this.myRange.getEndOffset()) {
                return true;
            }
            if (this.myProcessHeadingWhitespace) {
                return range.getEndOffset() < this.myRange.getStartOffset();
            }
            return range.getEndOffset() <= this.myRange.getStartOffset();
        }

        public int getStartOffset() {
            return this.myRange.getStartOffset();
        }

        public boolean isReadOnly(TextRange range, boolean rootIsRightBlock) {
            if (this.myRange.getStartOffset() >= range.getEndOffset() && rootIsRightBlock) {
                return false;
            }
            return range.getStartOffset() > this.myRange.getEndOffset() || range.getEndOffset() < this.myRange.getStartOffset();
        }

        public TextRange getTextRange() {
            return this.myRange;
        }

        public void setTextRange(TextRange range) {
            this.myRange = range;
        }

        public TextRange getNonEmptyTextRange() {
            return new TextRange(this.myRange.getStartOffset(), this.myRange.getStartOffset() == this.myRange.getEndOffset() ? this.myRange.getEndOffset() + 1 : this.myRange.getEndOffset());
        }

        public String toString() {
            return this.myRange.toString() + (this.myProcessHeadingWhitespace ? "+" : "");
        }
    }
}

