/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FrameStateManagerImpl
extends FrameStateManager
implements ApplicationComponent {
    private final CopyOnWriteArrayList<FrameStateListener> myListeners = ContainerUtil.createEmptyCOWList();
    private boolean myShouldSynchronize = false;
    private final Alarm mySyncAlarm = new Alarm();

    public FrameStateManagerImpl(final ApplicationImpl app) {
        app.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void applicationActivated(IdeFrame ideFrame) {
                FrameStateManagerImpl.this.mySyncAlarm.cancelAllRequests();
                if (FrameStateManagerImpl.this.myShouldSynchronize) {
                    FrameStateManagerImpl.this.myShouldSynchronize = false;
                    FrameStateManagerImpl.this.fireActivationEvent();
                }
            }

            public void applicationDeactivated(IdeFrame ideFrame) {
                FrameStateManagerImpl.this.mySyncAlarm.cancelAllRequests();
                FrameStateManagerImpl.this.mySyncAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!app.isActive()) {
                            FrameStateManagerImpl.this.myShouldSynchronize = true;
                            FrameStateManagerImpl.this.fireDeactivationEvent();
                        }
                    }
                }, 200);
            }
        });
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("FrameStateManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/FrameStateManagerImpl.getComponentName must not return null");
        }
        return "FrameStateManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void fireDeactivationEvent() {
        for (FrameStateListener listener : this.myListeners) {
            listener.onFrameDeactivated();
        }
    }

    private void fireActivationEvent() {
        for (FrameStateListener listener : this.myListeners) {
            listener.onFrameActivated();
        }
    }

    public synchronized void addListener(FrameStateListener listener) {
        this.myListeners.add(listener);
    }

    public synchronized void removeListener(FrameStateListener listener) {
        this.myListeners.remove(listener);
    }
}

