/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SelectInContextImpl
implements SelectInContext {
    protected final PsiFile myPsiFile;

    protected SelectInContextImpl(PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPsiFile.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/SelectInContextImpl.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile vFile = this.myPsiFile.getVirtualFile();
        assert (vFile != null);
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/SelectInContextImpl.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    public Object getSelectorInFile() {
        return this.myPsiFile;
    }

    @Nullable
    public static SelectInContext createContext(AnActionEvent event) {
        VirtualFile file;
        Navigatable descriptor;
        DataContext dataContext = event.getDataContext();
        SelectInContext result = SelectInContextImpl.createEditorContext(dataContext);
        if (result != null) {
            return result;
        }
        JComponent sourceComponent = SelectInContextImpl.getEventComponent(event);
        if (sourceComponent == null) {
            return null;
        }
        SelectInContext selectInContext = (SelectInContext)SelectInContext.DATA_KEY.getData(dataContext);
        if (selectInContext == null) {
            selectInContext = SelectInContextImpl.createPsiContext(event);
        }
        if (selectInContext == null && (descriptor = (Navigatable)PlatformDataKeys.NAVIGATABLE.getData(dataContext)) instanceof OpenFileDescriptor && (file = ((OpenFileDescriptor)descriptor).getFile()).isValid()) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            selectInContext = OpenFileDescriptorContext.create(project, file);
        }
        if (selectInContext == null) {
            VirtualFile virtualFile = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext);
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (virtualFile != null && project != null) {
                return new VirtualFileSelectInContext(project, virtualFile);
            }
        }
        return selectInContext;
    }

    @Nullable
    private static SelectInContext createEditorContext(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            return null;
        }
        VirtualFile file = FileEditorManagerEx.getInstanceEx(project).getFile(editor);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (editor instanceof TextEditor) {
            return new TextEditorContext((TextEditor)editor, psiFile);
        }
        return new SimpleSelectInContext(psiFile);
    }

    @Nullable
    private static SelectInContext createPsiContext(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        PsiElement psiElement = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return new SimpleSelectInContext(psiFile, psiElement);
    }

    @Nullable
    private static JComponent getEventComponent(AnActionEvent event) {
        Object source;
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent != null && (source = inputEvent.getSource()) instanceof JComponent) {
            return (JComponent)source;
        }
        return SelectInContextImpl.safeCast(PlatformDataKeys.CONTEXT_COMPONENT.getData(event.getDataContext()), JComponent.class);
    }

    @Nullable
    private static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    private static class VirtualFileSelectInContext
    implements SelectInContext {
        private final Project myProject;
        private final VirtualFile myVirtualFile;

        public VirtualFileSelectInContext(Project project, VirtualFile virtualFile) {
            this.myProject = project;
            this.myVirtualFile = virtualFile;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/actions/SelectInContextImpl$VirtualFileSelectInContext.getProject must not return null");
            }
            return project;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/actions/SelectInContextImpl$VirtualFileSelectInContext.getVirtualFile must not return null");
            }
            return virtualFile;
        }

        @Nullable
        public Object getSelectorInFile() {
            return this.myVirtualFile;
        }

        @Nullable
        public FileEditorProvider getFileEditorProvider() {
            return null;
        }
    }

    private static class SimpleSelectInContext
    extends SelectInContextImpl {
        private final PsiElement myElementToSelect;

        public SimpleSelectInContext(PsiFile psiFile) {
            this(psiFile, (PsiElement)psiFile);
        }

        public FileEditorProvider getFileEditorProvider() {
            return new FileEditorProvider(){

                public FileEditor openFileEditor() {
                    VirtualFile file = SimpleSelectInContext.this.myElementToSelect.getContainingFile().getVirtualFile();
                    if (file == null) {
                        return null;
                    }
                    FileEditor[] fileEditors = FileEditorManager.getInstance((Project)SimpleSelectInContext.this.getProject()).openFile(file, false);
                    return fileEditors.length > 0 ? fileEditors[0] : null;
                }
            };
        }

        public SimpleSelectInContext(PsiFile psiFile, PsiElement elementToSelect) {
            super(psiFile);
            this.myElementToSelect = elementToSelect;
        }
    }

    private static class OpenFileDescriptorContext
    extends SelectInContextImpl {
        public OpenFileDescriptorContext(PsiFile psiFile) {
            super(psiFile);
        }

        public FileEditorProvider getFileEditorProvider() {
            return new FileEditorProvider(){

                public FileEditor openFileEditor() {
                    return FileEditorManager.getInstance((Project)OpenFileDescriptorContext.this.getProject()).openFile(OpenFileDescriptorContext.this.getVirtualFile(), false)[0];
                }
            };
        }

        @Nullable
        public static SelectInContext create(Project project, VirtualFile file) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return null;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return null;
            }
            return new OpenFileDescriptorContext(psiFile);
        }
    }

    private static class TextEditorContext
    extends SelectInContextImpl {
        private final TextEditor myEditor;

        public TextEditorContext(TextEditor editor, PsiFile psiFile) {
            super(psiFile);
            this.myEditor = editor;
        }

        public FileEditorProvider getFileEditorProvider() {
            return new FileEditorProvider(){

                public FileEditor openFileEditor() {
                    return TextEditorContext.this.myEditor;
                }
            };
        }

        @Override
        public Object getSelectorInFile() {
            if (this.myPsiFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                return super.getSelectorInFile();
            }
            int offset = this.myEditor.getEditor().getCaretModel().getOffset();
            if (offset >= 0 && offset < this.myPsiFile.getTextLength()) {
                return this.myPsiFile.findElementAt(offset);
            }
            return super.getSelectorInFile();
        }
    }
}

