/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.navigationToolbar.NavBarModel");
    private List<Object> myModel = Collections.emptyList();
    private int mySelectedIndex;
    private final Project myProject;
    private static final SimpleTextAttributes WOLFED = new SimpleTextAttributes(null, null, Color.red, 8);
    private final NavBarModelListener myNotificator;

    public NavBarModel(Project project) {
        this.myProject = project;
        this.myNotificator = (NavBarModelListener)project.getMessageBus().syncPublisher(NavBarModelListener.NAV_BAR);
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    @Nullable
    public Object getSelectedValue() {
        return this.getElement(this.mySelectedIndex);
    }

    @Nullable
    public Object getElement(int index) {
        if (index != -1 && index < this.myModel.size()) {
            return this.myModel.get(index);
        }
        return null;
    }

    public int size() {
        return this.myModel.size();
    }

    public boolean isEmpty() {
        return this.myModel.isEmpty();
    }

    public int getIndexByModel(int index) {
        if (index < 0) {
            return this.myModel.size() + index;
        }
        if (index >= this.myModel.size() && this.myModel.size() > 0) {
            return index % this.myModel.size();
        }
        return index;
    }

    protected void updateModel(DataContext dataContext) {
        if (LaterInvocator.isInModalContext()) {
            return;
        }
        PsiElement psiElement = (PsiElement)LangDataKeys.PSI_FILE.getData(dataContext);
        if (psiElement == null) {
            psiElement = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if ((psiElement = NavBarModel.normalize(psiElement)) != null && psiElement.isValid()) {
            this.updateModel(psiElement);
        } else {
            if (UISettings.getInstance().SHOW_NAVIGATION_BAR) {
                return;
            }
            Object moduleOrProject = LangDataKeys.MODULE.getData(dataContext);
            if (moduleOrProject == null) {
                moduleOrProject = LangDataKeys.PROJECT.getData(dataContext);
            }
            if (moduleOrProject != null) {
                this.setModel(Collections.singletonList(moduleOrProject));
            }
        }
    }

    protected void updateModel(final PsiElement psiElement) {
        final HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        for (VirtualFile root : projectRootManager.getContentRoots()) {
            VirtualFile parent = root.getParent();
            if (parent != null && projectFileIndex.isInContent(parent)) continue;
            roots.add(root);
        }
        final ArrayList<Object> updatedModel = new ArrayList<Object>();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                NavBarModel.this.traverseToRoot(psiElement, roots, updatedModel);
            }
        });
        this.setModel(updatedModel);
    }

    private void setModel(List<Object> model) {
        if (!((Object)model).equals(this.myModel)) {
            this.myModel = model;
            this.myNotificator.modelChanged();
            this.mySelectedIndex = this.myModel.size() - 1;
            this.myNotificator.selectionChanged();
        }
    }

    public void updateModel(Object object) {
        if (object instanceof PsiElement) {
            this.updateModel((PsiElement)object);
        } else if (object instanceof Module) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(this.myProject);
            l.add(object);
            this.setModel(l);
        }
    }

    private void traverseToRoot(@NotNull PsiElement psiElement, Set<VirtualFile> roots, List<Object> model) {
        Object resultElement;
        block14: {
            block15: {
                block13: {
                    if (psiElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/navigationToolbar/NavBarModel.traverseToRoot must not be null");
                    }
                    if (!psiElement.isValid()) {
                        return;
                    }
                    PsiFile containingFile = psiElement.getContainingFile();
                    if (!(containingFile == null || containingFile.getVirtualFile() != null && containingFile.getViewProvider().isPhysical())) {
                        return;
                    }
                    resultElement = psiElement = psiElement.getOriginalElement();
                    if (containingFile == null) break block13;
                    for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
                        resultElement = modelExtension.adjustElement((PsiElement)resultElement);
                    }
                    PsiDirectory containingDirectory = containingFile.getContainingDirectory();
                    if (containingDirectory != null) {
                        this.traverseToRoot((PsiElement)containingDirectory, roots, model);
                    }
                    break block14;
                }
                if (!(psiElement instanceof PsiDirectory)) break block15;
                PsiDirectory psiDirectory = (PsiDirectory)psiElement;
                if (roots.contains(psiDirectory.getVirtualFile())) break block14;
                PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
                if (parentDirectory == null) {
                    VirtualFile jar = PathUtil.getLocalFile((VirtualFile)psiDirectory.getVirtualFile());
                    if (ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(jar)) {
                        parentDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(jar.getParent());
                    }
                }
                if (parentDirectory == null) break block14;
                this.traverseToRoot((PsiElement)parentDirectory, roots, model);
                break block14;
            }
            if (psiElement instanceof PsiFileSystemItem) {
                PsiDirectory parentDirectory;
                VirtualFile virtualFile = ((PsiFileSystemItem)psiElement).getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                resultElement = virtualFile.isDirectory() ? psiManager.findDirectory(virtualFile) : psiManager.findFile(virtualFile);
                if (resultElement == null) {
                    return;
                }
                VirtualFile parentVFile = virtualFile.getParent();
                if (parentVFile != null && !roots.contains(parentVFile) && (parentDirectory = psiManager.findDirectory(parentVFile)) != null) {
                    this.traverseToRoot((PsiElement)parentDirectory, roots, model);
                }
            } else {
                PsiElement el = psiElement;
                for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
                    PsiElement parent = modelExtension.getParent(el);
                    if (parent == null) continue;
                    this.traverseToRoot(parent, roots, model);
                }
            }
        }
        model.add(resultElement);
    }

    protected boolean hasChildren(Object object) {
        if (!NavBarModel.checkValid(object)) {
            return false;
        }
        return !this.calcElementChildren(object).isEmpty();
    }

    static boolean checkValid(final Object object) {
        if (object instanceof Project) {
            return !((Project)object).isDisposed();
        }
        if (object instanceof Module) {
            return !((Module)object).isDisposed();
        }
        if (object instanceof PsiElement) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return ((PsiElement)object).isValid();
                }
            });
        }
        return object != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static String getPresentableText(Object object, Window window) {
        String string;
        if (!NavBarModel.checkValid(object)) {
            string = IdeBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/navigationToolbar/NavBarModel.getPresentableText must not return null");
            return string;
        }
        for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            String text = modelExtension.getPresentableText(object);
            if (text == null) continue;
            boolean truncated = false;
            if (window != null) {
                int windowWidth = window.getWidth();
                while (window.getFontMetrics(window.getFont()).stringWidth(text) + 100 > windowWidth && text.length() > 10) {
                    text = text.substring(0, text.length() - 10);
                    truncated = true;
                }
            }
            if ((string = text + (truncated ? "..." : "")) == null) throw new IllegalStateException("@NotNull method com/intellij/ide/navigationToolbar/NavBarModel.getPresentableText must not return null");
            return string;
        }
        LOG.error("Failed to find navbar presentable text for " + object);
        string = object.toString();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/ide/navigationToolbar/NavBarModel.getPresentableText must not return null");
    }

    protected SimpleTextAttributes getTextAttributes(final Object object, boolean selected) {
        if (!NavBarModel.checkValid(object)) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        if (object instanceof PsiElement) {
            VirtualFile vDir;
            if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return ((PsiElement)object).isValid();
                }
            })).booleanValue()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            PsiFile psiFile = ((PsiElement)object).getContainingFile();
            if (psiFile != null) {
                VirtualFile virtualFile = psiFile.getVirtualFile();
                return new SimpleTextAttributes(null, selected ? null : FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile).getColor(), Color.red, WolfTheProblemSolver.getInstance((Project)this.myProject).isProblemFile(virtualFile) ? 8 : 0);
            }
            if (object instanceof PsiDirectory && ((vDir = ((PsiDirectory)object).getVirtualFile()).getParent() == null || ProjectRootsUtil.isModuleContentRoot(vDir, this.myProject))) {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            if (NavBarPanel.wolfHasProblemFilesBeneath((PsiElement)object)) {
                return WOLFED;
            }
        } else if (object instanceof Module) {
            if (WolfTheProblemSolver.getInstance((Project)this.myProject).hasProblemFilesBeneath((Module)object)) {
                return WOLFED;
            }
        } else if (object instanceof Project) {
            Module[] modules;
            final Project project = (Project)object;
            for (Module module : modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

                public Module[] compute() {
                    return ModuleManager.getInstance((Project)project).getModules();
                }
            })) {
                if (!WolfTheProblemSolver.getInstance((Project)project).hasProblemFilesBeneath(module)) continue;
                return WOLFED;
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public static void getDirectoryChildren(PsiDirectory psiDirectory, Object rootElement, List<Object> result) {
        PsiElement[] children;
        ModuleFileIndex moduleFileIndex = rootElement instanceof Module ? ModuleRootManager.getInstance((Module)((Module)rootElement)).getFileIndex() : null;
        for (PsiElement child : children = psiDirectory.getChildren()) {
            VirtualFile virtualFile;
            if (child == null || !child.isValid() || moduleFileIndex != null && (virtualFile = PsiUtilBase.getVirtualFile((PsiElement)child)) != null && !moduleFileIndex.isInContent(virtualFile)) continue;
            result.add(NavBarModel.normalize(child));
        }
    }

    @Nullable
    private static PsiElement normalize(PsiElement child) {
        if (child == null) {
            return null;
        }
        for (NavBarModelExtension modelExtension : (NavBarModelExtension[])Extensions.getExtensions(NavBarModelExtension.EP_NAME)) {
            if ((child = modelExtension.adjustElement(child)) != null) continue;
            return null;
        }
        return child;
    }

    List<Object> calcElementChildren(final Object object) {
        Object rootElement;
        if (!NavBarModel.checkValid(object)) {
            return new ArrayList<Object>();
        }
        final ArrayList<Object> result = new ArrayList<Object>();
        Object object2 = rootElement = this.size() > 1 ? this.getElement(1) : null;
        if (!(object instanceof Project) && rootElement instanceof Module && ((Module)rootElement).isDisposed()) {
            return result;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (object instanceof Project) {
            result.addAll(Arrays.asList((Object[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

                public Module[] compute() {
                    return ModuleManager.getInstance((Project)((Project)object)).getModules();
                }
            })));
        } else if (object instanceof Module) {
            Module module = (Module)object;
            if (!module.isDisposed()) {
                VirtualFile[] roots;
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                for (final VirtualFile root : roots = moduleRootManager.getContentRoots()) {
                    PsiDirectory psiDirectory = (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

                        public PsiDirectory compute() {
                            return psiManager.findDirectory(root);
                        }
                    });
                    if (psiDirectory == null) continue;
                    result.add(psiDirectory);
                }
            }
        } else if (object instanceof PsiDirectoryContainer) {
            PsiDirectory[] psiDirectories;
            final PsiDirectoryContainer psiPackage = (PsiDirectoryContainer)object;
            for (final PsiDirectory psiDirectory : psiDirectories = (PsiDirectory[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory[]>(){

                public PsiDirectory[] compute() {
                    return rootElement instanceof Module ? psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)((Module)rootElement))) : psiPackage.getDirectories();
                }
            })) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        NavBarModel.getDirectoryChildren(psiDirectory, rootElement, result);
                    }
                });
            }
        } else if (object instanceof PsiDirectory) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    NavBarModel.getDirectoryChildren((PsiDirectory)object, rootElement, result);
                }
            });
        }
        Collections.sort(result, new SiblingsComparator());
        return result;
    }

    public Object get(int index) {
        return this.myModel.get(index);
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.mySelectedIndex != selectedIndex) {
            this.mySelectedIndex = selectedIndex;
            this.myNotificator.selectionChanged();
        }
    }

    private static final class SiblingsComparator
    implements Comparator<Object> {
        private SiblingsComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Pair<Integer, String> w1 = SiblingsComparator.getWeightedName(o1);
            Pair<Integer, String> w2 = SiblingsComparator.getWeightedName(o2);
            if (w1 == null) {
                return w2 == null ? 0 : -1;
            }
            if (w2 == null) {
                return 1;
            }
            if (!((Integer)w1.first).equals(w2.first)) {
                return -((Integer)w1.first).intValue() + (Integer)w2.first;
            }
            return ((String)w1.second).compareToIgnoreCase((String)w2.second);
        }

        @Nullable
        private static Pair<Integer, String> getWeightedName(Object object) {
            if (object instanceof Module) {
                return Pair.create((Object)5, (Object)((Module)object).getName());
            }
            if (object instanceof PsiDirectoryContainer) {
                return Pair.create((Object)4, (Object)((PsiDirectoryContainer)object).getName());
            }
            if (object instanceof PsiDirectory) {
                return Pair.create((Object)4, (Object)((PsiDirectory)object).getName());
            }
            if (object instanceof PsiFile) {
                return Pair.create((Object)2, (Object)((PsiFile)object).getName());
            }
            if (object instanceof PsiNamedElement) {
                return Pair.create((Object)3, (Object)((PsiNamedElement)object).getName());
            }
            return null;
        }
    }
}

