/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class EditScopesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.scopeView.EditScopesAction");

    public EditScopesAction() {
        this.getTemplatePresentation().setIcon(ScopeViewPane.ICON);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        LOG.assertTrue(project != null);
        final String scopeName = ProjectView.getInstance(project).getCurrentProjectViewPane().getSubId();
        LOG.assertTrue(scopeName != null);
        final ScopeChooserConfigurable scopeChooserConfigurable = ScopeChooserConfigurable.getInstance(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)scopeChooserConfigurable, new Runnable(){

            @Override
            public void run() {
                scopeChooserConfigurable.selectNodeInTree(scopeName);
            }
        });
    }

    public void update(AnActionEvent e) {
        String scopeName;
        super.update(e);
        e.getPresentation().setEnabled(false);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project != null && (scopeName = ProjectView.getInstance(project).getCurrentProjectViewPane().getSubId()) != null) {
            e.getPresentation().setEnabled(true);
        }
    }
}

