/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startupWizard;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startupWizard.StartupWizardModel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.wizard.WizardNavigationState;
import com.intellij.ui.wizard.WizardStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class SelectPluginsStep
extends WizardStep<StartupWizardModel> {
    private JPanel myRootPanel;
    private JList myPluginsList;
    private JTextArea myDescriptionArea;
    private JButton myEnableAllButton;
    private JButton myDisableAllButton;
    private final List<IdeaPluginDescriptor> myPlugins;
    private final Set<String> myDisabledPluginIds;
    private final String myRequirePlugin;
    private static final String[] ourSuffixes = new String[]{"integration", "support", "plugin"};

    public SelectPluginsStep(String title, Set<String> disabledPluginIds, String requirePlugin) {
        super(title, "Select the plugins to enable. Disabling unused plugins will improve IDE startup speed and performance.\n\nTo change plugin settings later, go to Settings | Plugins.", null);
        this.$$$setupUI$$$();
        this.myPlugins = new ArrayList<IdeaPluginDescriptor>();
        this.myDisabledPluginIds = disabledPluginIds;
        this.myRequirePlugin = requirePlugin;
        this.myPluginsList.setCellRenderer(new ListCellRenderer(){
            private final JCheckBox myCheckbox = new JCheckBox();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.myCheckbox.setBackground(UIUtil.getListSelectionBackground());
                    this.myCheckbox.setForeground(UIUtil.getListSelectionForeground());
                } else {
                    this.myCheckbox.setBackground(UIUtil.getListBackground());
                    this.myCheckbox.setForeground(UIUtil.getListForeground());
                }
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)value;
                this.myCheckbox.setText(SelectPluginsStep.getAbbreviatedName(descriptor) + SelectPluginsStep.this.buildRequires(descriptor));
                this.myCheckbox.setSelected(!SelectPluginsStep.this.isDisabledPlugin(descriptor));
                return this.myCheckbox;
            }
        });
        this.myPluginsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IdeaPluginDescriptor pluginDescriptor = SelectPluginsStep.this.getSelectedPlugin();
                if (pluginDescriptor != null) {
                    String description = pluginDescriptor.getDescription();
                    SelectPluginsStep.this.myDescriptionArea.setText(description);
                    SelectPluginsStep.this.myDescriptionArea.moveCaretPosition(0);
                } else {
                    SelectPluginsStep.this.myDescriptionArea.setText("Select a plugin to see its description");
                }
            }
        });
        this.myPluginsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectPluginsStep.this.toggleSelection();
                e.consume();
            }
        });
        this.myPluginsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    SelectPluginsStep.this.toggleSelection();
                }
            }
        });
        this.myEnableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPluginsStep.this.setAllPluginsEnabled(true);
            }
        });
        this.myDisableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPluginsStep.this.setAllPluginsEnabled(false);
            }
        });
    }

    private String buildRequires(IdeaPluginDescriptor descriptor) {
        StringBuffer requiresBuffer = new StringBuffer();
        for (PluginId id : SelectPluginsStep.getNonOptionalDependencies(descriptor)) {
            IdeaPluginDescriptor dependent = this.findPlugin(id);
            if (dependent == null) continue;
            String name = SelectPluginsStep.getAbbreviatedName(dependent);
            if (requiresBuffer.length() == 0) {
                requiresBuffer.append(" (requires ");
            } else {
                requiresBuffer.append(", ");
            }
            requiresBuffer.append(name);
        }
        if (requiresBuffer.length() > 0) {
            requiresBuffer.append(")");
        }
        return requiresBuffer.toString();
    }

    private static List<PluginId> getNonOptionalDependencies(IdeaPluginDescriptor descriptor) {
        ArrayList<PluginId> result = new ArrayList<PluginId>();
        for (PluginId pluginId : descriptor.getDependentPluginIds()) {
            if (pluginId.getIdString().equals("com.intellij") || ArrayUtil.contains((Object)pluginId, (Object[])descriptor.getOptionalDependentPluginIds())) continue;
            result.add(pluginId);
        }
        return result;
    }

    private static String getAbbreviatedName(IdeaPluginDescriptor descriptor) {
        String name = descriptor.getName();
        for (String suffix : ourSuffixes) {
            if (!name.toLowerCase().endsWith(suffix)) continue;
            return name.substring(0, name.length() - suffix.length()).trim();
        }
        return name;
    }

    private boolean isDisabledPlugin(IdeaPluginDescriptor descriptor) {
        return this.myDisabledPluginIds.contains(descriptor.getPluginId().toString());
    }

    private void toggleSelection() {
        Object[] selection;
        IdeaPluginDescriptor descriptor = this.getSelectedPlugin();
        if (descriptor == null) {
            return;
        }
        boolean willDisable = !this.isDisabledPlugin(descriptor);
        for (Object o : selection = this.myPluginsList.getSelectedValues()) {
            IdeaPluginDescriptor desc = (IdeaPluginDescriptor)o;
            if (!willDisable) {
                this.setPluginEnabledWithDependencies(desc);
                continue;
            }
            this.setPluginDisabledWithDependents(desc);
        }
        this.myPluginsList.repaint();
    }

    private void setPluginDisabledWithDependents(IdeaPluginDescriptor desc) {
        this.setPluginEnabled(desc, false);
        for (IdeaPluginDescriptor plugin : this.myPlugins) {
            if (!ArrayUtil.contains((Object)desc.getPluginId(), (Object[])plugin.getDependentPluginIds()) || ArrayUtil.contains((Object)desc.getPluginId(), (Object[])plugin.getOptionalDependentPluginIds())) continue;
            this.setPluginDisabledWithDependents(plugin);
        }
    }

    private void setAllPluginsEnabled(boolean value) {
        for (IdeaPluginDescriptor descriptor : this.myPlugins) {
            this.setPluginEnabled(descriptor, value);
        }
        this.myPluginsList.repaint();
    }

    private void setPluginEnabledWithDependencies(IdeaPluginDescriptor desc) {
        this.setPluginEnabled(desc, true);
        for (PluginId id : SelectPluginsStep.getNonOptionalDependencies(desc)) {
            IdeaPluginDescriptor dependent = this.findPlugin(id);
            if (dependent == null) continue;
            this.setPluginEnabledWithDependencies(dependent);
        }
    }

    @Nullable
    private IdeaPluginDescriptor findPlugin(PluginId id) {
        for (IdeaPluginDescriptor plugin : this.myPlugins) {
            if (!plugin.getPluginId().equals(id)) continue;
            return plugin;
        }
        return null;
    }

    private void setPluginEnabled(IdeaPluginDescriptor desc, boolean value) {
        if (value) {
            this.myDisabledPluginIds.remove(desc.getPluginId().toString());
        } else {
            this.myDisabledPluginIds.add(desc.getPluginId().toString());
        }
    }

    @Nullable
    private IdeaPluginDescriptor getSelectedPlugin() {
        int leadSelectionIndex = this.myPluginsList.getSelectionModel().getLeadSelectionIndex();
        return leadSelectionIndex < 0 ? null : this.myPlugins.get(leadSelectionIndex);
    }

    @Override
    public JComponent prepare(WizardNavigationState state) {
        this.myRootPanel.revalidate();
        return this.myRootPanel;
    }

    public void addPlugin(IdeaPluginDescriptor pluginDescriptor) {
        this.myPlugins.add(pluginDescriptor);
    }

    public void fillPlugins() {
        Collections.sort(this.myPlugins, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.myPluginsList.setModel(new CollectionListModel(this.myPlugins));
        this.myPluginsList.setSelectedIndex(0);
    }

    public String getRequirePlugin() {
        return this.myRequirePlugin;
    }

    public List<IdeaPluginDescriptor> getPlugins() {
        return this.myPlugins;
    }

    @Override
    public WizardStep onNext(StartupWizardModel model) {
        SelectPluginsStep selectPluginsStep;
        String id;
        WizardStep next = super.onNext(model);
        if (next instanceof SelectPluginsStep && (id = (selectPluginsStep = (SelectPluginsStep)next).getRequirePlugin()) != null && model.getDisabledPluginIds().contains(id) && !model.isLast(next)) {
            for (IdeaPluginDescriptor descriptor : selectPluginsStep.getPlugins()) {
                model.getDisabledPluginIds().add(descriptor.getPluginId().getIdString());
            }
            return model.getNextFor(next);
        }
        return next;
    }

    @Override
    public WizardStep onPrevious(StartupWizardModel model) {
        SelectPluginsStep selectPluginsStep;
        String id;
        WizardStep prev = super.onPrevious(model);
        if (prev instanceof SelectPluginsStep && (id = (selectPluginsStep = (SelectPluginsStep)prev).getRequirePlugin()) != null && model.getDisabledPluginIds().contains(id) && !model.isFirst(prev)) {
            return model.getPreviousFor(prev);
        }
        return prev;
    }

    @Override
    public String getHelpId() {
        return "plugin.configuration.wizard";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JTextArea jTextArea;
        JList jList;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.myPluginsList = jList = new JList();
        jScrollPane.setViewportView(jList);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel.add((Component)jScrollPane2, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 3, null, null, null));
        this.myDescriptionArea = jTextArea = new JTextArea();
        jTextArea.setText("Select a plugin to see its description");
        jTextArea.setRows(4);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        ((Component)jTextArea).setBackground(UIManager.getColor("Label.background"));
        ((Component)jTextArea).setFont(UIManager.getFont("Label.font"));
        jScrollPane2.setViewportView(jTextArea);
        this.myEnableAllButton = jButton2 = new JButton();
        jButton2.setText("Enable All");
        jPanel.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDisableAllButton = jButton = new JButton();
        jButton.setText("Disable All");
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

