/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.ide.util.DirectoryChooserView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooser
extends DialogWrapper {
    private final DirectoryChooserView myView;

    public DirectoryChooser(Project project) {
        this(project, new DirectoryChooserModuleTreeView(project));
    }

    public DirectoryChooser(Project project, DirectoryChooserView view) {
        super(project, true);
        this.myView = view;
        this.init();
    }

    protected JComponent createCenterPanel() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DirectoryChooser.this.enableButtons();
            }
        };
        this.myView.onSelectionChange(runnable);
        JComponent component = this.myView.getComponent();
        JScrollPane jScrollPane = new JScrollPane(component);
        int prototypeWidth = component.getFontMetrics(component.getFont()).stringWidth("X:\\1234567890\\1234567890\\com\\company\\system\\subsystem");
        jScrollPane.setPreferredSize(new Dimension(Math.max(300, prototypeWidth), 300));
        this.installEnterAction(component);
        return jScrollPane;
    }

    private void installEnterAction(JComponent component) {
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        Object oldActionKey = inputMap.get(enterKeyStroke);
        final Action oldAction = oldActionKey != null ? actionMap.get(oldActionKey) : null;
        inputMap.put(enterKeyStroke, "clickButton");
        actionMap.put("clickButton", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryChooser.this.isOKActionEnabled()) {
                    DirectoryChooser.this.doOKAction();
                } else if (oldAction != null) {
                    oldAction.actionPerformed(e);
                }
            }
        });
    }

    protected String getDimensionServiceKey() {
        return "chooseDestDirectoryDialog";
    }

    private static String[] splitPath(String path) {
        int nextSeparator;
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((nextSeparator = path.indexOf(File.separatorChar, index)) != -1) {
            list.add(path.substring(index, nextSeparator));
            index = nextSeparator + 1;
        }
        list.add(path.substring(index, path.length()));
        return ArrayUtil.toStringArray(list);
    }

    private void buildFragments() {
        ArrayList<String[]> pathes = new ArrayList<String[]>();
        for (int i = 0; i < this.myView.getItemsSize(); ++i) {
            ItemWrapper item = this.myView.getItemByIndex(i);
            pathes.add(DirectoryChooser.splitPath(item.getPresentableUrl()));
        }
        FragmentBuilder headBuilder = new FragmentBuilder(pathes){

            @Override
            protected void append(String fragment, StringBuffer buffer) {
                buffer.append(this.mySeparator);
                buffer.append(fragment);
            }

            @Override
            protected int getFragmentIndex(String[] path, int index) {
                return path.length > index ? index : -1;
            }
        };
        String commonHead = headBuilder.execute();
        final int headLimit = headBuilder.getIndex();
        FragmentBuilder tailBuilder = new FragmentBuilder(pathes){

            @Override
            protected void append(String fragment, StringBuffer buffer) {
                buffer.insert(0, fragment + this.mySeparator);
            }

            @Override
            protected int getFragmentIndex(String[] path, int index) {
                int result = path.length - 1 - index;
                return result > headLimit ? result : -1;
            }
        };
        String commonTail = tailBuilder.execute();
        int tailLimit = tailBuilder.getIndex();
        for (int i = 0; i < this.myView.getItemsSize(); ++i) {
            ItemWrapper item = this.myView.getItemByIndex(i);
            String special = DirectoryChooser.concat((String[])pathes.get(i), headLimit, tailLimit);
            item.setFragments(DirectoryChooser.createFragments(commonHead, special, commonTail));
        }
    }

    @Nullable
    private static String concat(String[] strings, int headLimit, int tailLimit) {
        if (strings.length <= headLimit + tailLimit) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        for (int i = headLimit; i < strings.length - tailLimit; ++i) {
            buffer.append(separator);
            buffer.append(strings[i]);
            separator = File.separator;
        }
        return buffer.toString();
    }

    private static PathFragment[] createFragments(String head, String special, String tail) {
        ArrayList<PathFragment> list = new ArrayList<PathFragment>(3);
        if (head != null) {
            if (special != null || tail != null) {
                list.add(new PathFragment(head + File.separatorChar, true));
            } else {
                return new PathFragment[]{new PathFragment(head, true)};
            }
        }
        if (special != null) {
            if (tail != null) {
                list.add(new PathFragment(special + File.separatorChar, false));
            } else {
                list.add(new PathFragment(special, false));
            }
        }
        if (tail != null) {
            list.add(new PathFragment(tail, true));
        }
        return list.toArray(new PathFragment[list.size()]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView.getComponent();
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project, String postfixToShow) {
        this.fillList(directories, defaultSelection, project, postfixToShow, null);
    }

    public void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project, Map<PsiDirectory, String> postfixes) {
        this.fillList(directories, defaultSelection, project, null, postfixes);
    }

    private void fillList(PsiDirectory[] directories, @Nullable PsiDirectory defaultSelection, Project project, String postfixToShow, Map<PsiDirectory, String> postfixes) {
        PsiDirectory directory;
        int i;
        if (this.myView.getItemsSize() > 0) {
            this.myView.clearItems();
        }
        if (defaultSelection == null && directories.length > 0) {
            defaultSelection = directories[0];
        }
        int selectionIndex = -1;
        for (i = 0; i < directories.length; ++i) {
            directory = directories[i];
            if (!directory.equals(defaultSelection)) continue;
            selectionIndex = i;
            break;
        }
        if (selectionIndex < 0 && directories.length == 1) {
            selectionIndex = 0;
        }
        if (selectionIndex < 0) {
            VirtualFile[] sourceRoots;
            PsiManager manager = PsiManager.getInstance((Project)project);
            for (VirtualFile sourceRoot : sourceRoots = ProjectRootManager.getInstance((Project)project).getContentSourceRoots()) {
                PsiDirectory directory2;
                if (!sourceRoot.isDirectory() || (directory2 = manager.findDirectory(sourceRoot)) == null || !DirectoryChooser.isParent(defaultSelection, directory2)) continue;
                defaultSelection = directory2;
                break;
            }
        }
        for (i = 0; i < directories.length; ++i) {
            directory = directories[i];
            String postfixForDirectory = postfixes == null ? postfixToShow : postfixes.get(directory);
            ItemWrapper itemWrapper = new ItemWrapper(directory, postfixForDirectory);
            this.myView.addItem(itemWrapper);
            if (selectionIndex >= 0 || !DirectoryChooser.isParent(directory, defaultSelection)) continue;
            selectionIndex = i;
        }
        this.buildFragments();
        this.myView.listFilled();
        if (directories.length > 0) {
            this.myView.selectItemByIndex(selectionIndex);
        } else {
            this.myView.clearSelection();
        }
        this.enableButtons();
        this.myView.getComponent().repaint();
    }

    private static boolean isParent(PsiDirectory directory, PsiDirectory parentCandidate) {
        while (directory != null) {
            if (directory.equals(parentCandidate)) {
                return true;
            }
            directory = directory.getParentDirectory();
        }
        return false;
    }

    private void enableButtons() {
        this.setOKActionEnabled(this.myView.getSelectedItem() != null);
    }

    @Nullable
    public PsiDirectory getSelectedDirectory() {
        ItemWrapper wrapper = this.myView.getSelectedItem();
        if (wrapper == null) {
            return null;
        }
        return wrapper.myDirectory;
    }

    public static class PathFragment {
        private final String myText;
        private final boolean myCommon;

        public PathFragment(String text, boolean isCommon) {
            this.myText = text;
            this.myCommon = isCommon;
        }

        public String getText() {
            return this.myText;
        }

        public boolean isCommon() {
            return this.myCommon;
        }
    }

    public static class ItemWrapper {
        final PsiDirectory myDirectory;
        private PathFragment[] myFragments;
        private final String myPostfix;

        ItemWrapper(PsiDirectory directory, String postfix) {
            this.myDirectory = directory;
            this.myPostfix = postfix != null && postfix.length() > 0 ? postfix : null;
        }

        public PathFragment[] getFragments() {
            return this.myFragments;
        }

        public void setFragments(PathFragment[] fragments) {
            this.myFragments = fragments;
        }

        public Icon getIcon(FileIndex fileIndex) {
            if (this.myDirectory != null) {
                VirtualFile virtualFile = this.myDirectory.getVirtualFile();
                if (fileIndex.isInTestSourceContent(virtualFile)) {
                    return Icons.TEST_SOURCE_FOLDER;
                }
                if (fileIndex.isInSourceContent(virtualFile)) {
                    return Icons.SOURCE_FOLDERS_ICON;
                }
            }
            return Icons.FOLDER_ICON;
        }

        public String getPresentableUrl() {
            String directoryUrl = this.myDirectory != null ? this.myDirectory.getVirtualFile().getPresentableUrl() : "";
            return this.myPostfix != null ? directoryUrl + this.myPostfix : directoryUrl;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }
    }

    private static abstract class FragmentBuilder {
        private final ArrayList<String[]> myPaths;
        private final StringBuffer myBuffer = new StringBuffer();
        private int myIndex;
        protected String mySeparator = "";

        public FragmentBuilder(ArrayList<String[]> pathes) {
            this.myPaths = pathes;
            this.myIndex = 0;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Nullable
        public String execute() {
            String commonHead;
            while ((commonHead = this.getCommonFragment(this.myIndex)) != null) {
                this.append(commonHead, this.myBuffer);
                this.mySeparator = File.separator;
                ++this.myIndex;
            }
            return this.myIndex > 0 ? this.myBuffer.toString() : null;
        }

        protected abstract void append(String var1, StringBuffer var2);

        @Nullable
        private String getCommonFragment(int count) {
            String commonFragment = null;
            for (String[] path : this.myPaths) {
                int index = this.getFragmentIndex(path, count);
                if (index == -1) {
                    return null;
                }
                if (commonFragment == null) {
                    commonFragment = path[index];
                    continue;
                }
                if (Comparing.strEqual((String)commonFragment, (String)path[index], (boolean)SystemInfo.isFileSystemCaseSensitive)) continue;
                return null;
            }
            return commonFragment;
        }

        protected abstract int getFragmentIndex(String[] var1, int var2);
    }
}

