/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class TipPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.TipPanel");
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private final JCheckBox myCheckBox;
    private final JEditorPane browser;
    private final ArrayList<String> myTipPaths = new ArrayList();
    private final HashMap<String, Class<? extends ProductivityFeaturesProvider>> myPathsToProviderMap = new HashMap();
    @NonNls
    private static final String ELEMENT_TIP = "tip";
    @NonNls
    private static final String ATTRIBUTE_FILE = "file";

    public TipPanel() {
        this.setLayout(new BorderLayout());
        JLabel jlabel = new JLabel(IconLoader.getIcon((String)"/general/tip.png"));
        jlabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JLabel jlabel1 = new JLabel(IdeBundle.message((String)"label.did.you.know", (Object[])new Object[0]));
        Font font = jlabel1.getFont();
        jlabel1.setFont(font.deriveFont(0, font.getSize() + 4));
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)jlabel, "West");
        jpanel.add((Component)jlabel1, "Center");
        jpanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add((Component)jpanel, "North");
        this.browser = new JEditorPane();
        this.browser.setEditable(false);
        this.browser.setEditorKit(new HTMLEditorKit());
        this.browser.setBackground(Color.white);
        this.browser.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    // empty if block
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.browser);
        this.add((Component)scrollPane, "Center");
        this.myCheckBox = new JCheckBox(IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]), true);
        this.myCheckBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        final GeneralSettings settings = GeneralSettings.getInstance();
        this.myCheckBox.setSelected(settings.showTipsOnStartup());
        this.myCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                settings.setShowTipsOnStartup(e.getStateChange() == 1);
            }
        });
        this.add((Component)this.myCheckBox, "South");
        try {
            this.readTips();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 200);
    }

    public void prevTip() {
        String path;
        if (this.myTipPaths.size() == 0) {
            this.browser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (--lastTip <= 0) {
            path = this.myTipPaths.get(this.myTipPaths.size() - 1);
            lastTip = this.myTipPaths.size();
        } else {
            path = this.myTipPaths.get(lastTip - 1);
        }
        this.setTip(path, lastTip, this.browser, settings);
    }

    private void setTip(String path, int lastTip, JEditorPane browser, GeneralSettings settings) {
        TipUIUtil.openTipInBrowser(path, browser, this.myPathsToProviderMap.get(path));
        settings.setLastTip(lastTip);
    }

    public void nextTip() {
        String path;
        if (this.myTipPaths.size() == 0) {
            this.browser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (++lastTip - 1 >= this.myTipPaths.size()) {
            path = this.myTipPaths.get(0);
            lastTip = 1;
        } else {
            path = this.myTipPaths.get(lastTip - 1);
        }
        this.setTip(path, lastTip, this.browser, settings);
    }

    private void readTips() throws Exception {
        String tipsURL = "/tips/tips.xml";
        Document document = JDOMUtil.loadDocument((InputStream)this.getClass().getResource(tipsURL).openStream());
        if (document == null) {
            return;
        }
        for (Element element : document.getRootElement().getChildren(ELEMENT_TIP)) {
            this.myTipPaths.add(element.getAttributeValue(ATTRIBUTE_FILE));
        }
        ProductivityFeaturesProvider[] providers = (ProductivityFeaturesProvider[])ApplicationManager.getApplication().getComponents(ProductivityFeaturesProvider.class);
        for (int i = 0; i < providers.length; ++i) {
            ProductivityFeaturesProvider provider = providers[i];
            FeatureDescriptor[] featureDescriptors = provider.getFeatureDescriptors();
            for (int j = 0; featureDescriptors != null && j < featureDescriptors.length; ++j) {
                FeatureDescriptor featureDescriptor = featureDescriptors[j];
                this.myPathsToProviderMap.put(featureDescriptor.getTipFileName(), featureDescriptor.getProvider());
            }
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

