/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UndoRedoStacksHolder {
    private final Key<LinkedList<UndoableGroup>> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    private final boolean myUndo;
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();
    private final Map<DocumentReference, LinkedList<UndoableGroup>> myDocumentStacks = new HashMap();
    private final WeakList<Document> myDocumentsWithStacks = new WeakList();

    public UndoRedoStacksHolder(boolean isUndo) {
        this.myUndo = isUndo;
    }

    public LinkedList<UndoableGroup> getStack(Document d) {
        return this.getStack(UndoRedoStacksHolder.createReferenceOrGetOriginal(d));
    }

    private static DocumentReference createReferenceOrGetOriginal(Document d) {
        Document original = UndoManagerImpl.getOriginal(d);
        return DocumentReferenceManager.getInstance().create(original);
    }

    public LinkedList<UndoableGroup> getStack(@NotNull DocumentReference r) {
        if (r == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/impl/UndoRedoStacksHolder.getStack must not be null");
        }
        return r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
    }

    private LinkedList<UndoableGroup> doGetStackForFile(DocumentReference r) {
        LinkedList<UndoableGroup> result = this.myDocumentStacks.get(r);
        if (result == null) {
            result = new LinkedList();
            this.myDocumentStacks.put(r, result);
        }
        return result;
    }

    private LinkedList<UndoableGroup> doGetStackForDocument(DocumentReference r) {
        Document d = r.getDocument();
        LinkedList result = (LinkedList)d.getUserData(this.STACK_IN_DOCUMENT_KEY);
        if (result == null) {
            result = new LinkedList();
            d.putUserData(this.STACK_IN_DOCUMENT_KEY, result);
            this.myDocumentsWithStacks.add((Object)d);
        }
        return result;
    }

    public boolean hasActions(Collection<DocumentReference> refs) {
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty();
        }
        for (DocumentReference each : refs) {
            if (this.getStack(each).isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public UndoableGroup getLastAction(Collection<DocumentReference> refs) {
        UndoableGroup undoableGroup;
        if (refs.isEmpty()) {
            undoableGroup = this.myGlobalStack.getLast();
            if (undoableGroup == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/command/impl/UndoRedoStacksHolder.getLastAction must not return null");
            return undoableGroup;
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = this.myUndo ? -1 : Integer.MAX_VALUE;
        for (DocumentReference each : refs) {
            LinkedList<UndoableGroup> stack = this.getStack(each);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (!(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp)) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        undoableGroup = mostRecentAction;
        if (undoableGroup != null) return undoableGroup;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/command/impl/UndoRedoStacksHolder.getLastAction must not return null");
    }

    public Set<DocumentReference> collectClashingActions(UndoableGroup group) {
        UndoableGroup last;
        THashSet result = new THashSet();
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoableGroup last2 = this.getStack(each).getLast();
            if (last2 == group) continue;
            result.addAll(last2.getAffectedDocuments());
        }
        if (group.isGlobal() && (last = this.myGlobalStack.getLast()) != group) {
            result.addAll(last.getAffectedDocuments());
        }
        return result;
    }

    public void addToStacks(UndoableGroup group) {
        if (group.isGlobal()) {
            UndoRedoStacksHolder.doAddToStack(this.myGlobalStack, group, 10);
        }
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoRedoStacksHolder.doAddToStack(this.getStack(each), group, 100);
        }
    }

    private static void doAddToStack(LinkedList<UndoableGroup> stack, UndoableGroup group, int limit) {
        if (!group.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.addLast(group);
        while (stack.size() > limit) {
            stack.removeFirst();
        }
    }

    public void removeFromStacks(UndoableGroup group) {
        if (group.getAffectedDocuments().isEmpty()) {
            return;
        }
        if (group.isGlobal()) {
            assert (this.myGlobalStack.getLast() == group);
            this.myGlobalStack.removeLast();
        }
        for (DocumentReference each : group.getAffectedDocuments()) {
            LinkedList<UndoableGroup> stack = this.getStack(each);
            assert (stack.getLast() == group);
            stack.removeLast();
        }
    }

    public void clearStacks(boolean clearGlobal, Set<DocumentReference> affectedDocuments) {
        if (clearGlobal) {
            this.myGlobalStack.clear();
        }
        for (DocumentReference each : affectedDocuments) {
            LinkedList<UndoableGroup> stack = this.getStack(each);
            stack.clear();
            if (each.getFile() != null) {
                this.myDocumentStacks.remove(each);
                continue;
            }
            Document d = each.getDocument();
            d.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            this.myDocumentsWithStacks.remove((Object)d);
        }
    }

    public void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
    }

    public void invalidateAllGlobalActions() {
        UndoRedoStacksHolder.doInvalidateAllGlobalActions(this.myGlobalStack);
        for (DocumentReference each : this.getAffectedDocuments()) {
            UndoRedoStacksHolder.doInvalidateAllGlobalActions(this.getStack(each));
        }
    }

    private static void doInvalidateAllGlobalActions(LinkedList<UndoableGroup> stack) {
        for (UndoableGroup g : stack) {
            g.invalidateIfGlobal();
        }
    }

    public void collectAllAffectedDocuments(Collection<DocumentReference> result) {
        for (UndoableGroup each : this.myGlobalStack) {
            result.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result);
    }

    private void collectLocalAffectedDocuments(Collection<DocumentReference> result) {
        result.addAll(this.myDocumentStacks.keySet());
        for (Document each : this.myDocumentsWithStacks) {
            result.add(DocumentReferenceManager.getInstance().create(each));
        }
    }

    private Set<DocumentReference> getAffectedDocuments() {
        THashSet result = new THashSet();
        this.collectAllAffectedDocuments((Collection<DocumentReference>)result);
        return result;
    }

    public int getLastCommandTimestamp(DocumentReference r) {
        LinkedList<UndoableGroup> stack = this.getStack(r);
        if (stack.isEmpty()) {
            return 0;
        }
        return Math.max(stack.getFirst().getCommandTimestamp(), stack.getLast().getCommandTimestamp());
    }
}

