/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectPathMacroManager
extends BasePathMacroManager {
    private final ProjectEx myProject;

    public ProjectPathMacroManager(ProjectEx project) {
        this.myProject = project;
    }

    @Override
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = super.getExpandMacroMap();
        this.getExpandProjectHomeReplacements(result);
        return result;
    }

    @Override
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        result.putAll(super.getReplacePathMap());
        this.getProjectHomeReplacements(result, true);
        return result;
    }

    private void getProjectHomeReplacements(@NonNls ReplacePathToMacroMap result, boolean savePathsRelative) {
        String projectDir = this.getProjectDir();
        if (projectDir == null) {
            return;
        }
        String macro = "$PROJECT_DIR$";
        boolean check = false;
        for (File f = new File(projectDir.replace('/', File.separatorChar)); f != null && f.getParentFile() != null; f = f.getParentFile()) {
            String path = PathMacroMap.quotePath(f.getAbsolutePath());
            String s = macro;
            if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
                s = s + "/";
            }
            ProjectPathMacroManager.putIfAbsent(result, "file://" + path, "file://" + s, check);
            ProjectPathMacroManager.putIfAbsent(result, "file:/" + path, "file:/" + s, check);
            ProjectPathMacroManager.putIfAbsent(result, "file:" + path, "file:" + s, check);
            ProjectPathMacroManager.putIfAbsent(result, "jar://" + path, "jar://" + s, check);
            ProjectPathMacroManager.putIfAbsent(result, "jar:/" + path, "jar:/" + s, check);
            ProjectPathMacroManager.putIfAbsent(result, "jar:" + path, "jar:" + s, check);
            if (!(path.equalsIgnoreCase("e:/") || path.equalsIgnoreCase("r:/") || path.equalsIgnoreCase("p:/"))) {
                ProjectPathMacroManager.putIfAbsent(result, path, s, check);
            }
            if (!savePathsRelative) break;
            check = true;
            macro = macro + "/..";
        }
    }

    private void getExpandProjectHomeReplacements(ExpandMacroToPathMap result) {
        String projectDir = this.getProjectDir();
        if (projectDir == null) {
            return;
        }
        File f = new File(projectDir.replace('/', File.separatorChar));
        ProjectPathMacroManager.getExpandProjectHomeReplacements(result, f, "$PROJECT_DIR$");
    }

    private static void getExpandProjectHomeReplacements(ExpandMacroToPathMap result, File f, String macro) {
        if (f == null) {
            return;
        }
        ProjectPathMacroManager.getExpandProjectHomeReplacements(result, f.getParentFile(), macro + "/..");
        String path = PathMacroMap.quotePath(f.getAbsolutePath());
        String s = macro;
        if (StringUtil.endsWithChar((CharSequence)path, (char)'/')) {
            s = s + "/";
        }
        result.put(s, path);
    }

    @Nullable
    private String getProjectDir() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        return baseDir != null ? baseDir.getPath() : null;
    }
}

