/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.highlighter.WorkspaceFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public interface MergeVersion {
    public Document createWorkingDocument(Project var1);

    public void applyText(String var1, Project var2);

    public VirtualFile getFile();

    public byte[] getBytes() throws IOException;

    public FileType getContentType();

    public String getTextBeforeMerge();

    public static class MergeDocumentVersion
    implements MergeVersion {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.MergeVersion.MergeDocumentVersion");
        private final Document myDocument;
        private final String myOriginalText;
        private String myTextBeforeMerge;

        public MergeDocumentVersion(Document document, String originalText) {
            LOG.assertTrue(originalText != null, (Object)"text should not be null");
            LOG.assertTrue(document != null, (Object)"document should not be null");
            LOG.assertTrue(document.isWritable(), (Object)"document should be writable");
            this.myDocument = document;
            this.myOriginalText = originalText;
        }

        @Override
        public Document createWorkingDocument(final Project project) {
            final Document workingDocument = this.myDocument;
            workingDocument.setReadOnly(false);
            final DocumentReference ref = DocumentReferenceManager.getInstance().create(workingDocument);
            this.myTextBeforeMerge = this.myDocument.getText();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    MergeDocumentVersion.setDocumentText(workingDocument, MergeDocumentVersion.this.myOriginalText, DiffBundle.message((String)"merge.init.merge.content.command.name", (Object[])new Object[0]), project);
                    UndoManager.getInstance((Project)project).nonundoableActionPerformed(ref, false);
                }
            });
            return workingDocument;
        }

        @Override
        public void applyText(final String text, final Project project) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    FileType fileType;
                    MergeDocumentVersion.setDocumentText(MergeDocumentVersion.this.myDocument, text, DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]), project);
                    FileDocumentManager.getInstance().saveDocument(MergeDocumentVersion.this.myDocument);
                    VirtualFile file = MergeDocumentVersion.this.getFile();
                    if (file != null && ((fileType = file.getFileType()) instanceof ProjectFileType || fileType instanceof WorkspaceFileType || fileType instanceof ModuleFileType)) {
                        ProjectManagerEx.getInstanceEx().saveChangedProjectFile(file, project);
                    }
                }
            });
        }

        @Override
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myDocument);
        }

        @Override
        public byte[] getBytes() throws IOException {
            VirtualFile file = this.getFile();
            if (file != null) {
                return file.contentsToByteArray();
            }
            return this.myDocument.getText().getBytes();
        }

        @Override
        public FileType getContentType() {
            VirtualFile file = this.getFile();
            if (file == null) {
                return FileTypes.PLAIN_TEXT;
            }
            return FileTypeManager.getInstance().getFileTypeByFile(file);
        }

        private static void setDocumentText(final Document document, final String startingText, String name, Project project) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    document.replaceString(0, document.getTextLength(), (CharSequence)startingText);
                }
            }, name, null);
        }

        @Override
        public String getTextBeforeMerge() {
            return this.myTextBeforeMerge;
        }
    }
}

