/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class TextEndWithSelectionAction
extends TextComponentEditorAction {
    public TextEndWithSelectionAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void execute(Editor editor, DataContext dataContext) {
            int selectionStart = editor.getSelectionModel().getLeadSelectionOffset();
            int offset = editor.getDocument().getTextLength();
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().setSelection(selectionStart, offset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
        }
    }
}

