/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private final Map<IElementType, LayerDescriptor> myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
    private final Map<LayerDescriptor, Mapper> myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
    private final MappingSegments mySegments = new MappingSegments();
    private CharSequence myText;

    public LayeredLexerEditorHighlighter(SyntaxHighlighter highlighter, EditorColorsScheme scheme) {
        super(highlighter, scheme);
        this.setSegmentStorage(this.mySegments);
    }

    public synchronized void registerLayer(IElementType tokenType, LayerDescriptor layerHighlighter) {
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.mySegments.removeAll();
    }

    public synchronized void unregisterLayer(IElementType tokenType) {
        LayerDescriptor layer = this.myTokensToLayer.remove(tokenType);
        if (layer != null) {
            this.myLayerBuffers.remove(layer);
            this.mySegments.removeAll();
        }
    }

    @Override
    public void setText(CharSequence text) {
        this.updateLayers();
        this.myText = text;
        super.setText(text);
    }

    @Override
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex) {
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts = new FactoryMap<Mapper, LightMapper>(){

                protected LightMapper create(Mapper key) {
                    MappedRange predecessor = key.findPredecessor(startIndex);
                    return new LightMapper(key, predecessor != null ? predecessor.range.getEndOffset() : 0);
                }
            };

            @Override
            public void addToken(int i, int startOffset, int endOffset, int data, IElementType tokenType) {
                LayeredLexerEditorHighlighter.this.mySegments.setElementLight(i, startOffset, endOffset, data);
                Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(LayeredLexerEditorHighlighter.this.myText.subSequence(startOffset, endOffset), tokenType, i);
                }
            }

            @Override
            public void finish() {
                for (LightMapper mapper : this.docTexts.values()) {
                    mapper.finish();
                }
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(DocumentEvent e) {
        boolean b = this.updateLayers();
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            this.myText = e.getDocument().getCharsSequence();
            if (b) {
                this.setText(this.myText);
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlighterIterator createIterator(int startOffset) {
        boolean b = this.updateLayers();
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (b) {
                this.setText(this.myText);
            }
            return new LayeredHighlighterIterator(startOffset);
        }
    }

    @Nullable
    private Mapper getMappingDocument(IElementType token) {
        LayerDescriptor descriptor = this.myTokensToLayer.get(token);
        if (descriptor == null) {
            return null;
        }
        Mapper mapper = this.myLayerBuffers.get(descriptor);
        if (mapper == null) {
            mapper = new Mapper(descriptor);
            this.myLayerBuffers.put(descriptor, mapper);
        }
        return mapper;
    }

    private class LayeredHighlighterIterator
    implements HighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset = 0;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIterator(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.super.createIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping = ((LayeredLexerEditorHighlighter)LayeredLexerEditorHighlighter.this).mySegments.myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping != null) {
                this.myCurrentMapper = mapping.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }
    }

    private static class MappedRange {
        RangeMarker range;
        final Mapper mapper;
        final IElementType outerToken;

        MappedRange(Mapper mapper, RangeMarker range, IElementType outerToken) {
            this.mapper = mapper;
            this.range = range;
            this.outerToken = outerToken;
        }
    }

    private class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final EditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap = new HashMap<IElementType, TextAttributes>();
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor) {
            this.doc = new DocumentImpl(true);
            this.mySyntaxHighlighter = descriptor.getLayerHighlighter();
            this.myBackground = descriptor.getBackgroundKey();
            this.highlighter = new LexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor.getTokenSeparator();
            this.highlighter.setEditor((HighlighterClient)this);
            this.doc.addDocumentListener((DocumentListener)this.highlighter);
        }

        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(SyntaxHighlighterBase.pack((TextAttributesKey[])this.mySyntaxHighlighter.getTokenHighlights(tokenType), (TextAttributesKey)this.myBackground));
                this.myAttributesMap.put(tokenType, attrs);
            }
            return attrs;
        }

        public HighlighterIterator createIterator(MappedRange mapper, int shift) {
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        public void repaint(int start, int end) {
        }

        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        public void updateMapping(int tokenIndex, MappedRange oldMapping) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal((CharSequence)this.doc.getCharsSequence().subSequence(start, end), (CharSequence)tokenText)) {
                return;
            }
            this.doc.replaceString(start, end, tokenText);
            int newEnd = start + tokenText.length();
            if (oldMapping.range.getStartOffset() != start || oldMapping.range.getEndOffset() != newEnd) {
                oldMapping.range = this.doc.createRangeMarker(start, newEnd);
            }
        }

        public MappedRange insertMapping(int tokenIndex, IElementType outerToken) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex);
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, (CharSequence)new MergingCharSequence((CharSequence)this.mySeparator, tokenText));
            return new MappedRange(this, this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length), outerToken);
        }

        private CharSequence getTokenText(int tokenIndex) {
            return LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.mySegments.getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.mySegments.getSegmentEnd(tokenIndex));
        }

        @Nullable
        private MappedRange findPredecessor(int token) {
            --token;
            while (token >= 0) {
                MappedRange mappedRange = ((LayeredLexerEditorHighlighter)LayeredLexerEditorHighlighter.this).mySegments.myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        public void removeMapping(MappedRange mapping) {
            RangeMarker rangeMarker = mapping.range;
            if (rangeMarker.isValid()) {
                int start = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                this.doc.deleteString(start - this.mySeparator.length(), end);
            }
        }
    }

    private class MappingSegments
    extends SegmentArrayWithData {
        MappedRange[] myRanges = new MappedRange[64];

        private MappingSegments() {
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            LayeredLexerEditorHighlighter.this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void setElementAt(int i, int startOffset, int endOffset, int data) {
            this.setElementLight(i, startOffset, endOffset, (short)data);
            MappedRange range = this.myRanges[i];
            if (range != null) {
                range.mapper.removeMapping(range);
                this.myRanges[i] = null;
            }
            this.updateMappingForToken(i);
        }

        private void setElementLight(int i, int startOffset, int endOffset, int data) {
            super.setElementAt(i, startOffset, endOffset, data);
            this.myRanges = MappingSegments.reallocateArray(this.myRanges, i + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            FactoryMap<Mapper, Integer> mins = new FactoryMap<Mapper, Integer>(){

                protected Integer create(Mapper key) {
                    return Integer.MAX_VALUE;
                }
            };
            FactoryMap<Mapper, Integer> maxs = new FactoryMap<Mapper, Integer>(){

                protected Integer create(Mapper key) {
                    return 0;
                }
            };
            for (int i = startIndex; i < endIndex; ++i) {
                MappedRange range = this.myRanges[i];
                if (range != null && range.range.isValid()) {
                    mins.put(range.mapper, Math.min((Integer)mins.get(range.mapper), range.range.getStartOffset()));
                    maxs.put(range.mapper, Math.max((Integer)maxs.get(range.mapper), range.range.getEndOffset()));
                }
                this.myRanges[i] = null;
            }
            for (Mapper mapper : maxs.keySet()) {
                mapper.doc.deleteString((Integer)mins.get(mapper), (Integer)maxs.get(mapper));
            }
            this.myRanges = this.remove(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        public void replace(int startOffset, SegmentArrayWithData data, int len) {
            super.replace(startOffset, data, len);
            for (int i = startOffset; i < startOffset + len; ++i) {
                this.updateMappingForToken(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(SegmentArrayWithData segmentArray, int startIndex) {
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex);
                for (int i = startIndex; i < endIndex; ++i) {
                    short data = this.getSegmentData(i);
                    IElementType token = LexerEditorHighlighter.unpackToken(data);
                    processor.addToken(i, LayeredLexerEditorHighlighter.this.mySegments.getSegmentStart(i), LayeredLexerEditorHighlighter.this.mySegments.getSegmentEnd(i), data, token);
                }
                processor.finish();
            }
        }

        private void updateMappingForToken(int i) {
            short data = this.getSegmentData(i);
            IElementType token = LexerEditorHighlighter.unpackToken(data);
            Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i];
            if (mapper != null) {
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i] = mapper.insertMapping(i, token);
                    }
                } else {
                    this.myRanges[i] = mapper.insertMapping(i, token);
                }
            } else if (oldMapping != null) {
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i] = null;
            }
        }
    }

    private class LightMapper {
        final Mapper mapper;
        final StringBuilder text = new StringBuilder();
        final IntArrayList lengths = new IntArrayList();
        final List<IElementType> tokenTypes = new ArrayList<IElementType>();
        final TIntIntHashMap index2Global = new TIntIntHashMap();
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(CharSequence tokenText, IElementType tokenType, int globalIndex) {
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start = this.insertOffset;
            for (int i = 0; i < this.tokenTypes.size(); ++i) {
                IElementType type = this.tokenTypes.get(i);
                int len = this.lengths.get(i);
                start += this.mySeparator.length();
                int globalIndex = this.index2Global.get(i);
                assert (((LayeredLexerEditorHighlighter)LayeredLexerEditorHighlighter.this).mySegments.myRanges[globalIndex] == null) : LayeredLexerEditorHighlighter.access$400(LayeredLexerEditorHighlighter.this);
                ((LayeredLexerEditorHighlighter)LayeredLexerEditorHighlighter.this).mySegments.myRanges[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start, start + len), type);
                start += len;
            }
        }
    }
}

