/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditorListenerAdapter;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class CommonContentEntriesEditor
extends ModuleElementsEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.ContentEntriesEditor");
    public static final String NAME = ProjectBundle.message((String)"module.paths.title", (Object[])new Object[0]);
    public static final Icon ICON = IconLoader.getIcon((String)"/modules/sources.png");
    private static final Color BACKGROUND_COLOR = UIUtil.getListBackground();
    private static final Icon ADD_CONTENT_ENTRY_ICON = IconLoader.getIcon((String)"/modules/addContentEntry.png");
    protected ContentEntryTreeEditor myRootTreeEditor;
    private MyContentEntryEditorListener myContentEntryEditorListener;
    protected JPanel myEditorsPanel;
    private final Map<String, ContentEntryEditor> myEntryToEditorMap = new HashMap<String, ContentEntryEditor>();
    private String mySelectedEntryUrl;
    private VirtualFile myLastSelectedDir = null;
    private final String myModuleName;
    private final ModulesProvider myModulesProvider;
    private final ModuleConfigurationState myState;
    private final boolean myCanMarkSources;
    private final boolean myCanMarkTestSources;

    public CommonContentEntriesEditor(String moduleName, ModuleConfigurationState state, boolean canMarkSources, boolean canMarkTestSources) {
        super(state);
        this.myState = state;
        this.myModuleName = moduleName;
        this.myCanMarkSources = canMarkSources;
        this.myCanMarkTestSources = canMarkTestSources;
        this.myModulesProvider = state.getModulesProvider();
        final VirtualFileManagerAdapter fileManagerListener = new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                Module module = CommonContentEntriesEditor.this.getModule();
                if (module == null || module.isDisposed() || module.getProject().isDisposed()) {
                    return;
                }
                for (ContentEntryEditor editor : CommonContentEntriesEditor.this.myEntryToEditorMap.values()) {
                    editor.update();
                }
            }
        };
        final VirtualFileManagerEx fileManager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        fileManager.addVirtualFileManagerListener(fileManagerListener);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                fileManager.removeVirtualFileManagerListener(fileManagerListener);
            }
        });
    }

    @Override
    protected ModifiableRootModel getModel() {
        return this.myState.getRootModel();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.sources";
    }

    public String getDisplayName() {
        return NAME;
    }

    public Icon getIcon() {
        return ICON;
    }

    @Override
    public void disposeUIResources() {
        if (this.myRootTreeEditor != null) {
            this.myRootTreeEditor.setContentEntryEditor(null);
        }
        this.myEntryToEditorMap.clear();
        super.disposeUIResources();
    }

    @Override
    public JPanel createComponentImpl() {
        ContentEntry[] contentEntries;
        Module module = this.getModule();
        Project project = module.getProject();
        this.myContentEntryEditorListener = new MyContentEntryEditorListener();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.addAdditionalSettingsToPanel(mainPanel);
        JPanel entriesPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        AddContentEntryAction action = new AddContentEntryAction();
        action.registerCustomShortcutSet(67, 512, mainPanel);
        group.add((AnAction)action);
        this.myEditorsPanel = new ScrollablePanel(new VerticalStackLayout());
        this.myEditorsPanel.setBackground(BACKGROUND_COLOR);
        JScrollPane myScrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myEditorsPanel);
        entriesPanel.add((Component)new ToolbarPanel((JComponent)myScrollPane, (ActionGroup)group), "Center");
        Splitter splitter = new Splitter(false);
        splitter.setHonorComponentsMinimumSize(true);
        mainPanel.add((Component)splitter, "Center");
        JPanel editorsPanel = new JPanel(new GridBagLayout());
        splitter.setFirstComponent((JComponent)editorsPanel);
        editorsPanel.add((Component)entriesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myRootTreeEditor = this.createContentEntryTreeEditor(project);
        JComponent treeEditorComponent = this.myRootTreeEditor.createComponent();
        splitter.setSecondComponent(treeEditorComponent);
        JPanel innerPanel = this.createBottomControl(module);
        if (innerPanel != null) {
            mainPanel.add((Component)innerPanel, "South");
        }
        if ((contentEntries = this.getModel().getContentEntries()).length > 0) {
            for (ContentEntry contentEntry : contentEntries) {
                this.addContentEntryPanel(contentEntry.getUrl());
            }
            this.selectContentEntry(contentEntries[0].getUrl());
        }
        return mainPanel;
    }

    @Nullable
    protected JPanel createBottomControl(Module module) {
        return null;
    }

    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
        return new ContentEntryTreeEditor(project, this.myCanMarkSources, this.myCanMarkTestSources);
    }

    protected void addAdditionalSettingsToPanel(JPanel mainPanel) {
    }

    protected Module getModule() {
        return this.myModulesProvider.getModule(this.myModuleName);
    }

    protected void addContentEntryPanel(String contentEntry) {
        final ContentEntryEditor contentEntryEditor = this.createContentEntryEditor(contentEntry);
        contentEntryEditor.initUI();
        contentEntryEditor.addContentEntryEditorListener(this.myContentEntryEditorListener);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                contentEntryEditor.removeContentEntryEditorListener(CommonContentEntriesEditor.this.myContentEntryEditorListener);
            }
        });
        this.myEntryToEditorMap.put(contentEntry, contentEntryEditor);
        Border border = BorderFactory.createEmptyBorder(2, 2, 0, 2);
        JComponent component = contentEntryEditor.getComponent();
        Border componentBorder = component.getBorder();
        if (componentBorder != null) {
            border = BorderFactory.createCompoundBorder(border, componentBorder);
        }
        component.setBorder(border);
        this.myEditorsPanel.add(component);
    }

    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new ContentEntryEditor(contentEntryUrl, this.myCanMarkSources, this.myCanMarkTestSources){

            @Override
            protected ModifiableRootModel getModel() {
                return CommonContentEntriesEditor.this.getModel();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectContentEntry(String contentEntryUrl) {
        if (this.mySelectedEntryUrl != null && this.mySelectedEntryUrl.equals(contentEntryUrl)) {
            return;
        }
        try {
            ContentEntryEditor editor;
            if (this.mySelectedEntryUrl != null && (editor = this.myEntryToEditorMap.get(this.mySelectedEntryUrl)) != null) {
                editor.setSelected(false);
            }
            if (contentEntryUrl != null && (editor = this.myEntryToEditorMap.get(contentEntryUrl)) != null) {
                editor.setSelected(true);
                final JComponent component = editor.getComponent();
                final JComponent scroller = (JComponent)component.getParent();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scroller.scrollRectToVisible(component.getBounds());
                    }
                });
                this.myRootTreeEditor.setContentEntryEditor(editor);
                this.myRootTreeEditor.requestFocus();
            }
        }
        finally {
            this.mySelectedEntryUrl = contentEntryUrl;
        }
    }

    @Override
    public void moduleStateChanged() {
        if (this.myRootTreeEditor != null) {
            this.myRootTreeEditor.update();
        }
    }

    @Nullable
    private String getNextContentEntry(String contentEntryUrl) {
        return this.getAdjacentContentEntry(contentEntryUrl, 1);
    }

    @Nullable
    private String getAdjacentContentEntry(String contentEntryUrl, int delta) {
        ContentEntry[] contentEntries = this.getModel().getContentEntries();
        for (int idx = 0; idx < contentEntries.length; ++idx) {
            ContentEntry entry = contentEntries[idx];
            if (!contentEntryUrl.equals(entry.getUrl())) continue;
            int nextEntryIndex = (idx + delta) % contentEntries.length;
            if (nextEntryIndex < 0) {
                nextEntryIndex += contentEntries.length;
            }
            return nextEntryIndex == idx ? null : contentEntries[nextEntryIndex].getUrl();
        }
        return null;
    }

    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        ArrayList<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
        for (VirtualFile file : files) {
            if (this.isAlreadyAdded(file)) continue;
            ContentEntry contentEntry = this.getModel().addContentEntry(file);
            contentEntries.add(contentEntry);
        }
        return contentEntries;
    }

    private boolean isAlreadyAdded(VirtualFile file) {
        VirtualFile[] contentRoots;
        for (VirtualFile contentRoot : contentRoots = this.getModel().getContentRoots()) {
            if (!contentRoot.equals(file)) continue;
            return true;
        }
        return false;
    }

    public void saveData() {
    }

    protected void addContentEntryPanels(ContentEntry[] contentEntriesArray) {
        for (ContentEntry contentEntry : contentEntriesArray) {
            this.addContentEntryPanel(contentEntry.getUrl());
        }
        this.myEditorsPanel.revalidate();
        this.myEditorsPanel.repaint();
        this.selectContentEntry(contentEntriesArray[contentEntriesArray.length - 1].getUrl());
    }

    private class AddContentEntryAction
    extends IconWithTextAction
    implements DumbAware {
        private final FileChooserDescriptor myDescriptor;

        public AddContentEntryAction() {
            super(ProjectBundle.message((String)"module.paths.add.content.action", (Object[])new Object[0]), ProjectBundle.message((String)"module.paths.add.content.action.description", (Object[])new Object[0]), ADD_CONTENT_ENTRY_ICON);
            this.myDescriptor = new FileChooserDescriptor(false, true, true, false, true, true){

                public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                    AddContentEntryAction.this.validateContentEntriesCandidates(files);
                }
            };
            this.myDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)CommonContentEntriesEditor.this.getModule());
            this.myDescriptor.setTitle(ProjectBundle.message((String)"module.paths.add.content.title", (Object[])new Object[0]));
            this.myDescriptor.setDescription(ProjectBundle.message((String)"module.paths.add.content.prompt", (Object[])new Object[0]));
            this.myDescriptor.putUserData(FileChooserKeys.DELETE_ACTION_AVAILABLE, (Object)false);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile[] files = FileChooser.chooseFiles((Project)CommonContentEntriesEditor.this.myProject, (FileChooserDescriptor)this.myDescriptor, (VirtualFile)CommonContentEntriesEditor.this.myLastSelectedDir);
            if (files.length > 0) {
                CommonContentEntriesEditor.this.myLastSelectedDir = files[0];
                CommonContentEntriesEditor.this.addContentEntries(files);
            }
        }

        @Nullable
        private ContentEntry getContentEntry(String url) {
            ContentEntry[] entries;
            for (ContentEntry entry : entries = CommonContentEntriesEditor.this.getModel().getContentEntries()) {
                if (!entry.getUrl().equals(url)) continue;
                return entry;
            }
            return null;
        }

        private void validateContentEntriesCandidates(VirtualFile[] files) throws Exception {
            for (VirtualFile file : files) {
                Module[] modules;
                for (String contentEntryUrl : CommonContentEntriesEditor.this.myEntryToEditorMap.keySet()) {
                    VirtualFile contentEntryFile;
                    ContentEntry contentEntry = this.getContentEntry(contentEntryUrl);
                    if (contentEntry == null || (contentEntryFile = contentEntry.getFile()) == null) continue;
                    if (contentEntryFile.equals(file)) {
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.already.exists.error", (Object[])new Object[]{file.getPresentableUrl()}));
                    }
                    if (VfsUtil.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)file, (boolean)true)) {
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.intersect.error", (Object[])new Object[]{file.getPresentableUrl(), contentEntryFile.getPresentableUrl()}));
                    }
                    if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)contentEntryFile, (boolean)true)) continue;
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.dominate.error", (Object[])new Object[]{file.getPresentableUrl(), contentEntryFile.getPresentableUrl()}));
                }
                for (Module module : modules = CommonContentEntriesEditor.this.myModulesProvider.getModules()) {
                    VirtualFile[] moduleContentRoots;
                    if (CommonContentEntriesEditor.this.myModuleName.equals(module.getName())) continue;
                    ModuleRootModel rootModel = CommonContentEntriesEditor.this.myModulesProvider.getRootModel(module);
                    LOG.assertTrue(rootModel != null);
                    for (VirtualFile moduleContentRoot : moduleContentRoots = rootModel.getContentRoots()) {
                        if (!file.equals(moduleContentRoot)) continue;
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.duplicate.error", (Object[])new Object[]{file.getPresentableUrl(), module.getName()}));
                    }
                }
            }
        }
    }

    private final class MyContentEntryEditorListener
    extends ContentEntryEditorListenerAdapter {
        private MyContentEntryEditorListener() {
        }

        @Override
        public void editingStarted(ContentEntryEditor editor) {
            CommonContentEntriesEditor.this.selectContentEntry(editor.getContentEntryUrl());
        }

        @Override
        public void beforeEntryDeleted(ContentEntryEditor editor) {
            String entryUrl = editor.getContentEntryUrl();
            if (CommonContentEntriesEditor.this.mySelectedEntryUrl != null && CommonContentEntriesEditor.this.mySelectedEntryUrl.equals(entryUrl)) {
                CommonContentEntriesEditor.this.myRootTreeEditor.setContentEntryEditor(null);
            }
            String nextContentEntryUrl = CommonContentEntriesEditor.this.getNextContentEntry(entryUrl);
            this.removeContentEntryPanel(entryUrl);
            CommonContentEntriesEditor.this.selectContentEntry(nextContentEntryUrl);
            editor.removeContentEntryEditorListener(this);
        }

        @Override
        public void navigationRequested(ContentEntryEditor editor, VirtualFile file) {
            if (CommonContentEntriesEditor.this.mySelectedEntryUrl != null && CommonContentEntriesEditor.this.mySelectedEntryUrl.equals(editor.getContentEntryUrl())) {
                CommonContentEntriesEditor.this.myRootTreeEditor.requestFocus();
                CommonContentEntriesEditor.this.myRootTreeEditor.select(file);
            } else {
                CommonContentEntriesEditor.this.selectContentEntry(editor.getContentEntryUrl());
                CommonContentEntriesEditor.this.myRootTreeEditor.requestFocus();
                CommonContentEntriesEditor.this.myRootTreeEditor.select(file);
            }
        }

        private void removeContentEntryPanel(String contentEntryUrl) {
            ContentEntryEditor editor = (ContentEntryEditor)CommonContentEntriesEditor.this.myEntryToEditorMap.get(contentEntryUrl);
            if (editor != null) {
                CommonContentEntriesEditor.this.myEditorsPanel.remove(editor.getComponent());
                CommonContentEntriesEditor.this.myEntryToEditorMap.remove(contentEntryUrl);
                CommonContentEntriesEditor.this.myEditorsPanel.revalidate();
                CommonContentEntriesEditor.this.myEditorsPanel.repaint();
            }
        }
    }
}

