/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.Icons;
import java.awt.Color;
import javax.swing.Icon;

public class LibraryChooserElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.LibraryChooserElement");
    private final String myName;
    private final Library myLibrary;
    private LibraryOrderEntry myOrderEntry;
    public static final ElementsChooser.ElementProperties VALID_LIBRARY_ELEMENT_PROPERTIES = new ElementsChooser.ElementProperties(){

        @Override
        public Icon getIcon() {
            return Icons.LIBRARY_ICON;
        }

        @Override
        public Color getColor() {
            return null;
        }
    };
    public static final ElementsChooser.ElementProperties INVALID_LIBRARY_ELEMENT_PROPERTIES = new ElementsChooser.ElementProperties(){

        @Override
        public Icon getIcon() {
            return Icons.LIBRARY_ICON;
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }
    };

    public LibraryChooserElement(Library library, LibraryOrderEntry orderEntry) {
        this.myLibrary = library;
        this.myOrderEntry = orderEntry;
        if (this.myLibrary == null && this.myOrderEntry == null) {
            LOG.error("Both library and order entry are null");
            this.myName = ProjectBundle.message((String)"module.libraries.unknown.item", (Object[])new Object[0]);
        } else {
            this.myName = this.myLibrary != null ? this.myLibrary.getName() : this.myOrderEntry.getLibraryName();
        }
    }

    public String toString() {
        return this.myName;
    }

    public String getName() {
        return this.myName;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    public LibraryOrderEntry getOrderEntry() {
        return this.myOrderEntry;
    }

    public void setOrderEntry(LibraryOrderEntry orderEntry) {
        this.myOrderEntry = orderEntry;
    }

    public boolean isAttachedToProject() {
        return this.myOrderEntry != null;
    }

    public boolean isValid() {
        return this.myLibrary != null;
    }
}

