/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.IconSet;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JTree;

public class ToggleSourcesStateAction
extends ContentEntryEditingAction {
    private final ContentEntryTreeEditor myEntryTreeEditor;
    private final boolean myEditTestSources;

    public ToggleSourcesStateAction(JTree tree, ContentEntryTreeEditor entryEditor, boolean editTestSources) {
        super(tree);
        this.myEntryTreeEditor = entryEditor;
        this.myEditTestSources = editTestSources;
        Presentation templatePresentation = this.getTemplatePresentation();
        if (editTestSources) {
            templatePresentation.setText(ProjectBundle.message((String)"module.toggle.test.sources.action", (Object[])new Object[0]));
            templatePresentation.setDescription(ProjectBundle.message((String)"module.toggle.test.sources.action.description", (Object[])new Object[0]));
            templatePresentation.setIcon(IconSet.TEST_ROOT_FOLDER);
        } else {
            templatePresentation.setText(ProjectBundle.message((String)"module.toggle.sources.action", (Object[])new Object[0]));
            templatePresentation.setDescription(ProjectBundle.message((String)"module.toggle.sources.action.description", (Object[])new Object[0]));
            templatePresentation.setIcon(IconSet.SOURCE_ROOT_FOLDER);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return false;
        }
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        return this.myEditTestSources ? contentEntryEditor.isTestSource(selectedFiles[0]) : contentEntryEditor.isSource(selectedFiles[0]);
    }

    public void setSelected(AnActionEvent e, boolean isSelected) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        assert (selectedFiles != null && selectedFiles.length != 0);
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        for (VirtualFile selectedFile : selectedFiles) {
            SourceFolder sourceFolder = contentEntryEditor.getSourceFolder(selectedFile);
            if (isSelected) {
                if (sourceFolder == null) {
                    contentEntryEditor.addSourceFolder(selectedFile, this.myEditTestSources);
                    continue;
                }
                if (!(this.myEditTestSources ? !sourceFolder.isTestSource() : sourceFolder.isTestSource())) continue;
                contentEntryEditor.removeSourceFolder(sourceFolder);
                contentEntryEditor.addSourceFolder(selectedFile, this.myEditTestSources);
                continue;
            }
            if (sourceFolder == null) continue;
            contentEntryEditor.removeSourceFolder(sourceFolder);
        }
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setText(this.myEditTestSources ? ProjectBundle.message((String)"module.toggle.test.sources.action", (Object[])new Object[0]) : ProjectBundle.message((String)"module.toggle.sources.action", (Object[])new Object[0]));
    }
}

