/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.nodes;

import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingNodeSource {
    private final ComplexPackagingElement<?> mySourceElement;
    private final PackagingElementNode<?> mySourceParentNode;
    private final CompositePackagingElement<?> mySourceParentElement;
    private final Collection<PackagingNodeSource> myParentSources;

    public PackagingNodeSource(@NotNull ComplexPackagingElement<?> sourceElement, @NotNull PackagingElementNode<?> sourceParentNode, @NotNull CompositePackagingElement<?> sourceParentElement, @Nullable Collection<PackagingNodeSource> parentSources) {
        if (sourceElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource.<init> must not be null");
        }
        if (sourceParentNode == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource.<init> must not be null");
        }
        if (sourceParentElement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource.<init> must not be null");
        }
        this.mySourceElement = sourceElement;
        this.mySourceParentNode = sourceParentNode;
        this.mySourceParentElement = sourceParentElement;
        this.myParentSources = parentSources;
    }

    @NotNull
    public ComplexPackagingElement<?> getSourceElement() {
        ComplexPackagingElement<?> complexPackagingElement = this.mySourceElement;
        if (complexPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource.getSourceElement must not return null");
        }
        return complexPackagingElement;
    }

    @Nullable
    public Artifact getSourceArtifact() {
        if (this.mySourceElement instanceof ArtifactPackagingElement) {
            return ((ArtifactPackagingElement)this.mySourceElement).findArtifact((PackagingElementResolvingContext)this.mySourceParentNode.getContext());
        }
        return null;
    }

    @NotNull
    public PackagingElementNode<?> getSourceParentNode() {
        PackagingElementNode<?> packagingElementNode = this.mySourceParentNode;
        if (packagingElementNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource.getSourceParentNode must not return null");
        }
        return packagingElementNode;
    }

    @NotNull
    public CompositePackagingElement<?> getSourceParentElement() {
        CompositePackagingElement<?> compositePackagingElement = this.mySourceParentElement;
        if (compositePackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingNodeSource.getSourceParentElement must not return null");
        }
        return compositePackagingElement;
    }

    public Collection<PackagingNodeSource> getParentSources() {
        return this.myParentSources;
    }

    public String getPresentableName() {
        return this.mySourceElement.createPresentation(this.mySourceParentNode.getContext()).getPresentableName();
    }
}

