/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectsConvertor {
    public static final Convertor<FilePath, VirtualFile> FILEPATH_TO_VIRTUAL = new Convertor<FilePath, VirtualFile>(){

        public VirtualFile convert(FilePath fp) {
            return fp.getVirtualFile();
        }
    };
    public static final Convertor<VirtualFile, FilePath> VIRTUAL_FILEPATH = new Convertor<VirtualFile, FilePath>(){

        public FilePath convert(VirtualFile vf) {
            return new FilePathImpl(vf);
        }
    };
    public static final Convertor<FilePath, File> FILEPATH_FILE = new Convertor<FilePath, File>(){

        public File convert(FilePath fp) {
            return fp.getIOFile();
        }
    };
    public static final Convertor<File, FilePath> FILE_FILEPATH = new Convertor<File, FilePath>(){

        public FilePath convert(File file) {
            return FilePathImpl.create(file);
        }
    };
    public static final NotNullFunction<Object, Boolean> NOT_NULL = new NotNullFunction<Object, Boolean>(){

        @NotNull
        public Boolean fun(Object o) {
            Boolean bl = o != null;
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/ObjectsConvertor$5.fun must not return null");
            }
            return bl;
        }
    };

    private ObjectsConvertor() {
    }

    public static List<VirtualFile> fp2vf(Collection<FilePath> in) {
        return ObjectsConvertor.convert(in, FILEPATH_TO_VIRTUAL);
    }

    public static List<FilePath> vf2fp(List<VirtualFile> in) {
        return ObjectsConvertor.convert(in, VIRTUAL_FILEPATH);
    }

    public static List<File> fp2jiof(Collection<FilePath> in) {
        return ObjectsConvertor.convert(in, FILEPATH_FILE);
    }

    public static <T, S> List<S> convert(Collection<T> in, Convertor<T, S> convertor) {
        return ObjectsConvertor.convert(in, convertor, null);
    }

    public static <T, U, S extends U> List<S> convert(Collection<T> in, Convertor<T, S> convertor, @Nullable NotNullFunction<U, Boolean> outFilter) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (T t : in) {
            Object converted = convertor.convert(t);
            if (outFilter != null && !Boolean.TRUE.equals(outFilter.fun(converted))) continue;
            out.add(converted);
        }
        return out;
    }
}

