/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IgnoredFilesComponent {
    private final Project myProject;
    private final Set<IgnoredFileBean> myFilesToIgnore;

    public IgnoredFilesComponent(Project project) {
        this.myProject = project;
        this.myFilesToIgnore = new HashSet<IgnoredFileBean>();
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
            }

            public void after(List<? extends VFileEvent> events) {
                IgnoredFilesComponent.this.resetCaches();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IgnoredFileBean ... filesToIgnore) {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            this.myFilesToIgnore.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            return this.myFilesToIgnore.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(IgnoredFileBean ... filesToIgnore) {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            this.myFilesToIgnore.clear();
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgnoredFileBean[] getFilesToIgnore() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            return this.myFilesToIgnore.toArray(new IgnoredFileBean[this.myFilesToIgnore.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCaches() {
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                bean.resetCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoredFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/IgnoredFilesComponent.isIgnoredFile must not be null");
        }
        Set<IgnoredFileBean> set = this.myFilesToIgnore;
        synchronized (set) {
            if (this.myFilesToIgnore.size() == 0) {
                return false;
            }
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (!bean.matchesFile(file)) continue;
                return true;
            }
            return false;
        }
    }
}

