/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.changes.patch.PatchNameChecker;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreatePatchConfigurationPanel {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myFileNameField;
    private JCheckBox myReversePatchCheckbox;
    private JLabel myErrorLabel;
    private Consumer<Boolean> myOkEnabledListener;

    public CreatePatchConfigurationPanel() {
        this.$$$setupUI$$$();
        this.myFileNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setSelectedFile(new File(CreatePatchConfigurationPanel.this.myFileNameField.getText()));
                if (fileChooser.showSaveDialog((Component)CreatePatchConfigurationPanel.this.myFileNameField) != 0) {
                    return;
                }
                CreatePatchConfigurationPanel.this.myFileNameField.setText(fileChooser.getSelectedFile().getPath());
            }
        });
        this.myFileNameField.getTextField().addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                CreatePatchConfigurationPanel.this.checkName();
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        this.myFileNameField.getTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                CreatePatchConfigurationPanel.this.checkName();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                CreatePatchConfigurationPanel.this.checkName();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CreatePatchConfigurationPanel.this.checkName();
            }
        });
        this.myErrorLabel.setForeground(Color.RED);
        this.checkName();
    }

    private void checkName() {
        PatchNameChecker patchNameChecker = new PatchNameChecker(this.myFileNameField.getText());
        if (patchNameChecker.nameOk()) {
            this.myErrorLabel.setText("");
        } else {
            this.myErrorLabel.setText(patchNameChecker.getError());
        }
        if (this.myOkEnabledListener != null) {
            this.myOkEnabledListener.consume((Object)patchNameChecker.nameOk());
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void installOkEnabledListener(Consumer<Boolean> runnable) {
        this.myOkEnabledListener = runnable;
    }

    public String getFileName() {
        return this.myFileNameField.getText();
    }

    public void setFileName(File file) {
        this.myFileNameField.setText(file.getPath());
        this.checkName();
    }

    public boolean isReversePatch() {
        return this.myReversePatchCheckbox.isSelected();
    }

    public void setReversePatch(boolean reverse) {
        this.myReversePatchCheckbox.setSelected(reverse);
    }

    public boolean isOkToExecute() {
        return this.myErrorLabel.getText() == null || this.myErrorLabel.getText().length() == 0;
    }

    public String getError() {
        return this.myErrorLabel.getText() == null ? "" : this.myErrorLabel.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/VcsBundle").getString("create.patch.file.name.field"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFileNameField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        this.myReversePatchCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/VcsBundle").getString("create.patch.reverse.patch.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

