/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.SortableColumnModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;

public class VcsHistoryDialog
extends DialogWrapper
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.impl.VcsHistoryDialog");
    private final AbstractVcs myActiveVcs;
    private static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    private final DiffPanel myDiffPanel;
    private final Project myProject;
    private static final ColumnInfo REVISION = new ColumnInfo(VcsBundle.message((String)"column.name.revision.version", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getRevisionNumber();
        }
    };
    private static final ColumnInfo DATE = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.date", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            Date date = ((VcsFileRevision)object).getRevisionDate();
            if (date == null) {
                return "";
            }
            return DATE_FORMAT.format(date);
        }
    };
    private static final ColumnInfo MESSAGE = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.message", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getCommitMessage();
        }
    };
    private static final ColumnInfo AUTHOR = new ColumnInfo(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((VcsFileRevision)object).getAuthor();
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{REVISION, DATE, AUTHOR, MESSAGE};
    private final TableView myList;
    protected final List<VcsFileRevision> myRevisions;
    private final Splitter mySplitter;
    private final VirtualFile myFile;
    private final JCheckBox myChangesOnlyCheckBox = new JCheckBox(VcsBundle.message((String)"checkbox.show.changed.revisions.only", (Object[])new Object[0]));
    private final Map<VcsFileRevision, String> myCachedContents = new HashMap();
    private final JTextArea myComments = new JTextArea();
    private static final int CURRENT = 0;
    private boolean myIsInLoading = false;
    @NonNls
    private final String myHelpId;
    private boolean myIsDisposed = false;
    private final FileType myContentFileType;

    public VcsHistoryDialog(Project project, VirtualFile file, VcsHistoryProvider vcsHistoryProvider, VcsHistorySession session, AbstractVcs vcs) {
        super(project, true);
        this.myProject = project;
        this.myActiveVcs = vcs;
        this.myRevisions = new ArrayList<VcsFileRevision>();
        this.myFile = file;
        String helpId = vcsHistoryProvider.getHelpId();
        this.myHelpId = helpId != null ? helpId : "reference.dialogs.vcs.selection.history";
        final VcsDependentHistoryComponents components = vcsHistoryProvider.getUICustomization(session, (JComponent)this.getRootPane());
        this.myList = new TableView(new ListTableModel(VcsHistoryDialog.createColumns(components.getColumns())));
        ((SortableColumnModel)this.myList.getModel()).setSortable(false);
        this.myDiffPanel = DiffManager.getInstance().createDiffPanel(this.getWindow(), this.myProject);
        this.myRevisions.addAll(session.getRevisionList());
        VcsRevisionNumber currentRevisionNumber = session.getCurrentRevisionNumber();
        if (currentRevisionNumber != null) {
            this.myRevisions.add((VcsFileRevision)new CurrentRevision(file, currentRevisionNumber));
        }
        Collections.sort(this.myRevisions, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision rev1, VcsFileRevision rev2) {
                return VcsHistoryUtil.compare((VcsFileRevision)rev1, (VcsFileRevision)rev2);
            }
        });
        Collections.reverse(this.myRevisions);
        this.myContentFileType = FileTypeManager.getInstance().getFileTypeByFile(file);
        this.updateRevisionsList();
        this.mySplitter = new Splitter(true, this.getVcsConfiguration().FILE_HISTORY_DIALOG_SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent(this.myDiffPanel.getComponent());
        this.mySplitter.setSecondComponent(this.createBottomPanel(components.getDetailsComponent()));
        this.mySplitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    ((VcsHistoryDialog)VcsHistoryDialog.this).getVcsConfiguration().FILE_HISTORY_DIALOG_SPLITTER_PROPORTION = ((Float)evt.getNewValue()).floatValue();
                }
            }
        });
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision;
                if (VcsHistoryDialog.this.myList.getSelectedRowCount() == 1) {
                    revision = (VcsFileRevision)VcsHistoryDialog.this.myList.getItems().get(VcsHistoryDialog.this.myList.getSelectedRow());
                    VcsHistoryDialog.this.myComments.setText(revision.getCommitMessage());
                    VcsHistoryDialog.this.myComments.setCaretPosition(0);
                } else {
                    revision = null;
                    VcsHistoryDialog.this.myComments.setText("");
                }
                if (components.getRevisionListener() != null) {
                    components.getRevisionListener().consume((Object)revision);
                }
                VcsHistoryDialog.this.updateDiff();
            }
        });
        this.myChangesOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsHistoryDialog.this.updateRevisionsList();
            }
        });
        this.init();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                VcsHistoryDialog.this.myList.getSelectionModel().addSelectionInterval(0, 0);
            }
        });
        this.setTitle(VcsBundle.message((String)"dialog.title.history.for.file", (Object[])new Object[]{file.getName()}));
    }

    public void show() {
        this.myList.getSelectionModel().setSelectionInterval(0, 0);
        super.show();
    }

    private static ColumnInfo[] createColumns(ColumnInfo[] additionalColumns) {
        if (additionalColumns == null) {
            return COLUMNS;
        }
        ColumnInfo[] result = new ColumnInfo[additionalColumns.length + COLUMNS.length];
        System.arraycopy(COLUMNS, 0, result, 0, COLUMNS.length);
        System.arraycopy(additionalColumns, 0, result, COLUMNS.length, additionalColumns.length);
        return result;
    }

    protected synchronized String getContentOf(VcsFileRevision revision) {
        LOG.assertTrue(this.myCachedContents.containsKey(revision), (Object)revision.getRevisionNumber().asString());
        return this.myCachedContents.get(revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadContentsFor(VcsFileRevision[] revisions) {
        if (this.myIsInLoading) {
            return;
        }
        this.myIsInLoading = true;
        try {
            Map<VcsFileRevision, String> map = this.myCachedContents;
            synchronized (map) {
                final VcsFileRevision[] revisionsToLoad = this.revisionsNeededToBeLoaded(revisions);
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        progressIndicator.pushState();
                        try {
                            for (int i = 0; i < revisionsToLoad.length; ++i) {
                                final VcsFileRevision vcsFileRevision = revisionsToLoad[i];
                                progressIndicator.setText2(VcsBundle.message((String)"progress.text2.loading.revision", (Object[])new Object[]{vcsFileRevision.getRevisionNumber()}));
                                progressIndicator.setFraction((double)i / (double)revisionsToLoad.length);
                                if (VcsHistoryDialog.this.myCachedContents.containsKey(vcsFileRevision)) continue;
                                try {
                                    vcsFileRevision.loadContent();
                                }
                                catch (VcsException e) {
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.load.version.bocause.of.error", (Object[])new Object[]{vcsFileRevision.getRevisionNumber(), e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.load.version", (Object[])new Object[0]));
                                        }
                                    });
                                }
                                catch (ProcessCanceledException ex) {
                                    progressIndicator.popState();
                                    return;
                                }
                                String content = null;
                                try {
                                    byte[] byteContent = vcsFileRevision.getContent();
                                    if (byteContent != null) {
                                        content = new String(byteContent, VcsHistoryDialog.this.myFile.getCharset().name());
                                    }
                                }
                                catch (IOException e) {
                                    LOG.error((Throwable)e);
                                }
                                VcsHistoryDialog.this.myCachedContents.put(vcsFileRevision, content);
                            }
                        }
                        finally {
                            progressIndicator.popState();
                        }
                    }
                }, VcsBundle.message((String)"progress.title.loading.contents", (Object[])new Object[0]), false, this.myProject);
            }
        }
        finally {
            this.myIsInLoading = false;
        }
    }

    protected VcsFileRevision[] revisionsNeededToBeLoaded(VcsFileRevision[] revisions) {
        return revisions;
    }

    private void updateRevisionsList() {
        if (this.myIsInLoading) {
            return;
        }
        if (this.myChangesOnlyCheckBox.isSelected()) {
            this.loadContentsFor(this.myRevisions.toArray(new VcsFileRevision[this.myRevisions.size()]));
            ((ListTableModel)this.myList.getModel()).setItems(this.filteredRevisions());
            ((ListTableModel)this.myList.getModel()).fireTableDataChanged();
            this.updateDiff(0, 0);
        } else {
            ((ListTableModel)this.myList.getModel()).setItems(this.myRevisions);
            ((ListTableModel)this.myList.getModel()).fireTableDataChanged();
        }
    }

    private List<VcsFileRevision> filteredRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>();
        VcsFileRevision nextRevision = this.myRevisions.get(this.myRevisions.size() - 1);
        result.add(nextRevision);
        for (int i = this.myRevisions.size() - 2; i >= 0; --i) {
            VcsFileRevision vcsFileRevision = this.myRevisions.get(i);
            if (this.getContentToShow(nextRevision).equals(this.getContentToShow(vcsFileRevision))) continue;
            result.add(vcsFileRevision);
            nextRevision = vcsFileRevision;
        }
        Collections.reverse(result);
        return result;
    }

    private synchronized void updateDiff() {
        int[] selectedIndices = this.myList.getSelectedRows();
        if (selectedIndices.length == 0) {
            this.updateDiff(0, 0);
        } else if (selectedIndices.length == 1) {
            this.updateDiff(selectedIndices[0], 0);
        } else {
            this.updateDiff(selectedIndices[selectedIndices.length - 1], selectedIndices[0]);
        }
    }

    private synchronized void updateDiff(int first, int second) {
        VcsFileRevision secondRev;
        if (this.myIsDisposed || this.myIsInLoading) {
            return;
        }
        List items = ((ListTableModel)this.myList.getModel()).getItems();
        VcsFileRevision firstRev = (VcsFileRevision)items.get(first);
        if (VcsHistoryUtil.compare((VcsFileRevision)firstRev, (VcsFileRevision)(secondRev = (VcsFileRevision)items.get(second))) > 0) {
            VcsFileRevision tmp = firstRev;
            firstRev = secondRev;
            secondRev = tmp;
        }
        this.loadContentsFor(new VcsFileRevision[]{firstRev, secondRev});
        if (this.myIsDisposed) {
            return;
        }
        this.myDiffPanel.setContents((DiffContent)new SimpleContent(this.getContentToShow(firstRev), this.myContentFileType), (DiffContent)new SimpleContent(this.getContentToShow(secondRev), this.myContentFileType));
        this.myDiffPanel.setTitle1(VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{firstRev.getRevisionNumber()}));
        this.myDiffPanel.setTitle2(VcsBundle.message((String)"diff.content.title.revision.number", (Object[])new Object[]{secondRev.getRevisionNumber()}));
    }

    public synchronized void dispose() {
        this.myIsDisposed = true;
        this.myDiffPanel.dispose();
        super.dispose();
    }

    protected String getContentToShow(VcsFileRevision firstRev) {
        return this.getContentOf(firstRev);
    }

    private JComponent createBottomPanel(JComponent addComp) {
        Splitter splitter = new Splitter(true, this.getVcsConfiguration().FILE_HISTORY_DIALOG_COMMENTS_SPLITTER_PROPORTION);
        splitter.setDividerWidth(4);
        splitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    ((VcsHistoryDialog)VcsHistoryDialog.this).getVcsConfiguration().FILE_HISTORY_DIALOG_COMMENTS_SPLITTER_PROPORTION = ((Float)evt.getNewValue()).floatValue();
                }
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)this.createTablePanel(), "Center");
        tablePanel.add((Component)this.myChangesOnlyCheckBox, "North");
        splitter.setFirstComponent((JComponent)tablePanel);
        splitter.setSecondComponent(this.createComments(addComp));
        return splitter;
    }

    private VcsConfiguration getVcsConfiguration() {
        return this.myActiveVcs.getConfiguration();
    }

    private JComponent createComments(JComponent addComp) {
        Splitter splitter = new Splitter(false);
        JLabel label = new JLabel("Commit Message:"){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.getWidth(), 21);
            }
        };
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)label, "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myComments), "Center");
        this.myComments.setRows(5);
        this.myComments.setEditable(false);
        this.myComments.setLineWrap(true);
        splitter.setFirstComponent((JComponent)panel);
        splitter.setSecondComponent(addComp);
        return splitter;
    }

    private JComponent createTablePanel() {
        return ScrollPaneFactory.createScrollPane((JComponent)this.myList);
    }

    protected JComponent createCenterPanel() {
        return this.mySplitter;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpId);
    }

    protected Action[] createActions() {
        Action okAction = this.getOKAction();
        okAction.putValue("Name", VcsBundle.message((String)"close.tab.action.name", (Object[])new Object[0]));
        if (this.myHelpId != null) {
            return new Action[]{okAction, this.getHelpAction()};
        }
        return new Action[]{okAction};
    }

    protected String getDimensionServiceKey() {
        return "VCS.FileHistoryDialog";
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return this.myList.getSelectedObject();
        }
        return null;
    }
}

