/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaBlock;
import com.intellij.psi.formatter.java.JavaSpacePropertyProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SyntheticCodeBlock
implements Block,
JavaBlock {
    private final List<Block> mySubBlocks;
    private final Alignment myAlignment;
    private final Indent myIndentContent;
    private final CodeStyleSettings mySettings;
    private final Wrap myWrap;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.newXmlFormatter.java.SyntheticCodeBlock");
    private final TextRange myTextRange;
    private ChildAttributes myChildAttributes;
    private boolean myIsIncomplete = false;

    public SyntheticCodeBlock(List<Block> subBlocks, Alignment alignment, CodeStyleSettings settings, Indent indent, Wrap wrap) {
        this.myIndentContent = indent;
        if (subBlocks.isEmpty()) {
            LOG.assertTrue(false);
        }
        this.mySubBlocks = new ArrayList<Block>(subBlocks);
        this.myAlignment = alignment;
        this.mySettings = settings;
        this.myWrap = wrap;
        this.myTextRange = new TextRange(this.mySubBlocks.get(0).getTextRange().getStartOffset(), this.mySubBlocks.get(this.mySubBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SyntheticCodeBlock.getTextRange must not return null");
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SyntheticCodeBlock.getSubBlocks must not return null");
        }
        return list;
    }

    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return this.myIndentContent;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    public Spacing getSpacing(Block child1, Block child2) {
        return JavaSpacePropertyProcessor.getSpacing(AbstractJavaBlock.getTreeNode(child2), this.mySettings);
    }

    public String toString() {
        ASTNode treeNode = ((AbstractBlock)this.mySubBlocks.get(0)).getNode();
        TextRange textRange = this.getTextRange();
        return ((Object)treeNode.getPsi().getContainingFile().getText().subSequence(textRange.getStartOffset(), textRange.getEndOffset())).toString();
    }

    @Override
    public ASTNode getFirstTreeNode() {
        return AbstractJavaBlock.getTreeNode(this.mySubBlocks.get(0));
    }

    public void setChildAttributes(ChildAttributes childAttributes) {
        this.myChildAttributes = childAttributes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        if (this.myChildAttributes != null) {
            childAttributes = this.myChildAttributes;
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SyntheticCodeBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = new ChildAttributes(this.getIndent(), null);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SyntheticCodeBlock.getChildAttributes must not return null");
    }

    public boolean isIncomplete() {
        if (this.myIsIncomplete) {
            return true;
        }
        return this.getSubBlocks().get(this.getSubBlocks().size() - 1).isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIsIncomplete(boolean isIncomplete) {
        this.myIsIncomplete = isIncomplete;
    }
}

