/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.ShallowNodeComparator;

public class ASTShallowComparator
implements ShallowNodeComparator<ASTNode, ASTNode> {
    public ThreeState deepEqual(ASTNode oldNode, ASTNode newNode) {
        return ASTShallowComparator.textMatches(oldNode, newNode);
    }

    private static ThreeState textMatches(ASTNode oldNode, ASTNode newNode) {
        if (TreeUtil.isCollapsedChameleon(oldNode)) {
            return ((TreeElement)newNode).textMatches(oldNode.getText()) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (TreeUtil.isCollapsedChameleon(newNode)) {
            return ((TreeElement)oldNode).textMatches(newNode.getText()) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldNode instanceof LeafElement) {
            return ((LeafElement)oldNode).textMatches(newNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (oldNode instanceof PsiErrorElement && newNode instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)oldNode;
            PsiErrorElement e2 = (PsiErrorElement)newNode;
            if (!Comparing.equal((String)e1.getErrorDescription(), (String)e2.getErrorDescription())) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    }

    public boolean typesEqual(ASTNode n1, ASTNode n2) {
        return n1.getElementType() == n2.getElementType();
    }

    public boolean hashcodesEqual(ASTNode n1, ASTNode n2) {
        if (n1 instanceof LeafElement && n2 instanceof LeafElement) {
            return ASTShallowComparator.textMatches(n1, n2) == ThreeState.YES;
        }
        if (n1 instanceof PsiErrorElement && n2 instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)n1;
            PsiErrorElement e2 = (PsiErrorElement)n2;
            if (!Comparing.equal((String)e1.getErrorDescription(), (String)e2.getErrorDescription())) {
                return false;
            }
        }
        return ((TreeElement)n1).hc() == ((TreeElement)n2).hc();
    }
}

