/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        public PsiAnnotation fun(Project project, String text) {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(text, null);
        }
    };

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return (PsiJavaCodeReferenceElement)stub.getTreeElement().findChildByRoleAsPsiElement(119);
        }
        return (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)this, PsiJavaCodeReferenceElement.class);
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value, ANNOTATION_CREATOR);
    }

    public String toString() {
        return "PsiAnnotation";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList;
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            psiAnnotationParameterList = (PsiAnnotationParameterList)stub.getTreeElement().findChildByRoleAsPsiElement(14);
            if (psiAnnotationParameterList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.getParameterList must not return null");
            return psiAnnotationParameterList;
        }
        psiAnnotationParameterList = (PsiAnnotationParameterList)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiAnnotationParameterList.class);
        if (psiAnnotationParameterList != null) return psiAnnotationParameterList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.getParameterList must not return null");
    }

    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase((PsiElement)this);
    }

    public PsiAnnotationOwner getOwner() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiTypeElement) {
            return ((PsiTypeElement)parent).getOwner((PsiAnnotation)this);
        }
        if (parent instanceof PsiMethodReceiver || parent instanceof PsiTypeParameter) {
            return (PsiAnnotationOwner)parent;
        }
        PsiElement member = parent.getParent();
        String[] elementTypeFields = AnnotationsHighlightUtil.getApplicableElementTypeFields(member);
        if (elementTypeFields == null) {
            return null;
        }
        if (parent instanceof PsiAnnotationOwner && AnnotationsHighlightUtil.isAnnotationApplicableTo(this, true, elementTypeFields)) {
            return (PsiAnnotationOwner)parent;
        }
        Object typeElement = member instanceof PsiVariable ? ((PsiVariable)member).getTypeElement() : (member instanceof PsiMethod ? ((PsiMethod)member).getReturnTypeElement() : (parent instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)parent : null));
        return typeElement;
    }
}

