/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.inline.InlineRefactoringActionHandler;
import org.jetbrains.annotations.Nullable;

public class InlineAction
extends BasePlatformRefactoringAction {
    public InlineAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditor(PsiElement element, Editor editor) {
        return InlineAction.hasInlineActionHandler(element, PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)element.getProject()));
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && InlineAction.hasInlineActionHandler(elements[0], null);
    }

    private static boolean hasInlineActionHandler(PsiElement element, @Nullable Language editorLanguage) {
        for (InlineActionHandler handler : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler.isEnabledOnElement(element)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)(editorLanguage != null ? editorLanguage : element.getLanguage())).size() > 0;
    }

    @Override
    public RefactoringActionHandler getHandler(DataContext dataContext) {
        return new InlineRefactoringActionHandler();
    }

    @Override
    protected boolean isAvailableForLanguage(Language language) {
        for (InlineActionHandler handler : (InlineActionHandler[])Extensions.getExtensions((ExtensionPointName)InlineActionHandler.EP_NAME)) {
            if (!handler.isEnabledForLanguage(language)) continue;
            return true;
        }
        return InlineHandlers.getInlineHandlers((Language)language).size() > 0;
    }
}

