/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassDialog;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractSuperclassHandler
implements RefactoringActionHandler,
ExtractSuperclassDialog.Callback,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.superclass.title");
    private PsiClass mySubclass;
    private Project myProject;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractSuperclass/ExtractSuperclassHandler.invoke must not be null");
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractSuperclass");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(final @NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/extractSuperclass/ExtractSuperclassHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/extractSuperclass/ExtractSuperclassHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        this.mySubclass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.mySubclass)) {
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (this.mySubclass.isInterface()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractSuperclass");
            return;
        }
        if (this.mySubclass.isEnum()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.enum"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.extractSuperclass");
            return;
        }
        List<MemberInfo> memberInfos = MemberInfo.extractClassMembers(this.mySubclass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return true;
            }
        }, false);
        final ExtractSuperclassDialog dialog = new ExtractSuperclassDialog(project, this.mySubclass, memberInfos, this);
        dialog.show();
        if (!dialog.isOK() || !dialog.isExtractSuperclass()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        ExtractSuperclassHandler.this.doRefactoring(project, ExtractSuperclassHandler.this.mySubclass, dialog);
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, REFACTORING_NAME, null);
    }

    @Override
    public boolean checkConflicts(ExtractSuperclassDialog dialog) {
        PsiDirectory targetDirectory;
        PsiPackage targetPackage;
        MemberInfo[] infos = dialog.getSelectedMemberInfos();
        MultiMap<PsiElement, String> conflicts = PullUpConflictsUtil.checkConflicts(infos, this.mySubclass, null, targetPackage = (targetDirectory = dialog.getTargetDirectory()) != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null, targetDirectory, dialog.getContainmentVerifier());
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(Project project, PsiClass subclass, ExtractSuperclassDialog dialog) {
        String superclassName = dialog.getExtractedSuperName();
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        MemberInfo[] selectedMemberInfos = dialog.getSelectedMemberInfos();
        DocCommentPolicy javaDocPolicy = new DocCommentPolicy(dialog.getJavaDocPolicy());
        LocalHistoryAction a = LocalHistory.startAction((Project)this.myProject, (String)this.getCommandName(subclass, superclassName));
        try {
            PsiClass superclass = null;
            try {
                superclass = ExtractSuperClassUtil.extractSuperClass(project, targetDirectory, superclassName, subclass, selectedMemberInfos, javaDocPolicy);
            }
            finally {
                a.finish();
            }
            if (superclass != null) {
                ExtractClassUtil.askAndTurnRefsToSuper(project, subclass, superclass);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private String getCommandName(PsiClass subclass, String newName) {
        return RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{newName, UsageViewUtil.getDescriptiveName((PsiElement)subclass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass && !((PsiClass)elements[0]).isInterface() && !((PsiClass)elements[0]).isEnum();
    }
}

