/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.OverridingMethodsDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteExtendsClassUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteFieldWriteReference;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeletePrivatizeMethod;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class JavaSafeDeleteProcessor
implements SafeDeleteProcessorDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor");

    @Override
    public boolean handlesElement(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiParameter;
    }

    @Override
    @Nullable
    public NonCodeUsageSearchInfo findUsages(PsiElement element, PsiElement[] allElementsToDelete, List<UsageInfo> usages) {
        Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        if (element instanceof PsiClass) {
            JavaSafeDeleteProcessor.findClassUsages((PsiClass)element, allElementsToDelete, usages);
            if (element instanceof PsiTypeParameter) {
                JavaSafeDeleteProcessor.findTypeParameterExternalUsages((PsiTypeParameter)element, usages);
            }
        } else if (element instanceof PsiMethod) {
            insideDeletedCondition = JavaSafeDeleteProcessor.findMethodUsages((PsiMethod)element, allElementsToDelete, usages);
        } else if (element instanceof PsiField) {
            insideDeletedCondition = JavaSafeDeleteProcessor.findFieldUsages((PsiField)element, usages, allElementsToDelete);
        } else if (element instanceof PsiParameter) {
            LOG.assertTrue(((PsiParameter)element).getDeclarationScope() instanceof PsiMethod);
            JavaSafeDeleteProcessor.findParameterUsages((PsiParameter)element, usages);
        }
        return new NonCodeUsageSearchInfo(insideDeletedCondition, element);
    }

    @Override
    public Collection<? extends PsiElement> getElementsToSearch(PsiElement element, Collection<PsiElement> allElementsToDelete) {
        Project project = element.getProject();
        if (element instanceof PsiMethod) {
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)element, RefactoringBundle.message((String)"to.delete.with.usage.search"), allElementsToDelete);
            if (methods.length == 0) {
                return null;
            }
            return Arrays.asList(methods);
        }
        if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            String message;
            PsiMethod method = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            com.intellij.util.containers.HashSet parametersToDelete = new com.intellij.util.containers.HashSet();
            parametersToDelete.add((PsiParameter)element);
            int parameterIndex = method.getParameterList().getParameterIndex((PsiParameter)element);
            SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>((Set)parametersToDelete, parameterIndex){
                final /* synthetic */ Set val$parametersToDelete;
                final /* synthetic */ int val$parameterIndex;
                {
                    this.val$parametersToDelete = set;
                    this.val$parameterIndex = n;
                }

                public boolean process(MethodSignatureBackedByPsiMethod signature) {
                    this.val$parametersToDelete.add(signature.getMethod().getParameterList().getParameters()[this.val$parameterIndex]);
                    return true;
                }
            });
            OverridingMethodsSearch.search((PsiMethod)method).forEach((Processor)new Processor<PsiMethod>((Set)parametersToDelete, parameterIndex){
                final /* synthetic */ Set val$parametersToDelete;
                final /* synthetic */ int val$parameterIndex;
                {
                    this.val$parametersToDelete = set;
                    this.val$parameterIndex = n;
                }

                public boolean process(PsiMethod overrider) {
                    this.val$parametersToDelete.add(overrider.getParameterList().getParameters()[this.val$parameterIndex]);
                    return true;
                }
            });
            if (parametersToDelete.size() > 1 && Messages.showYesNoDialog((Project)project, (String)(message = RefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)method)})), (String)SafeDeleteHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon()) != 0) {
                return null;
            }
            return parametersToDelete;
        }
        return Collections.singletonList(element);
    }

    @Override
    public Collection<PsiElement> getAdditionalElementsToDelete(PsiElement element, Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            Project project = element.getProject();
            String propertyName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                String message;
                PsiMethod setter;
                boolean isStatic = field.hasModifierProperty("static");
                PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false);
                if (allElementsToDelete.contains(getter)) {
                    getter = null;
                }
                if (allElementsToDelete.contains(setter = PropertyUtil.findPropertySetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false))) {
                    setter = null;
                }
                if (askUser && (getter != null || setter != null) && Messages.showYesNoDialog((Project)project, (String)(message = RefactoringMessageUtil.getGetterSetterMessage(field.getName(), RefactoringBundle.message((String)"delete.title"), getter, setter)), (String)RefactoringBundle.message((String)"safe.delete.title"), (Icon)Messages.getQuestionIcon()) != 0) {
                    getter = null;
                    setter = null;
                }
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                if (setter != null) {
                    elements.add((PsiElement)setter);
                }
                if (getter != null) {
                    elements.add((PsiElement)getter);
                }
                return elements;
            }
        }
        return null;
    }

    @Override
    public Collection<String> findConflicts(PsiElement element, PsiElement[] allElementsToDelete) {
        PsiClass containingClass;
        if (element instanceof PsiMethod && !(containingClass = ((PsiMethod)element).getContainingClass()).hasModifierProperty("abstract")) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = ((PsiMethod)element).findSuperMethods()) {
                if (JavaSafeDeleteProcessor.isInside((PsiElement)superMethod, allElementsToDelete) || !superMethod.hasModifierProperty("abstract")) continue;
                String message = RefactoringBundle.message((String)"0.implements.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), RefactoringUIUtil.getDescription((PsiElement)superMethod, true)});
                return Collections.singletonList(message);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> overridingMethods = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage.isNonCodeUsage) {
                result.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                overridingMethods.add(usage);
                continue;
            }
            result.add(usage);
        }
        if (!overridingMethods.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(overridingMethods);
            } else {
                OverridingMethodsDialog dialog = new OverridingMethodsDialog(project, overridingMethods);
                dialog.show();
                if (!dialog.isOK()) {
                    return null;
                }
                result.addAll(dialog.getSelected());
            }
        }
        return result.toArray(new UsageInfo[result.size()]);
    }

    @Override
    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiVariable) {
            ((PsiVariable)element).normalizeDeclaration();
        }
    }

    public static Condition<PsiElement> getUsageInsideDeletedFilter(final PsiElement[] allElementsToDelete) {
        return new Condition<PsiElement>(){

            public boolean value(PsiElement usage) {
                return !(usage instanceof PsiFile) && JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete);
            }
        };
    }

    private static void findClassUsages(final PsiClass psiClass, final PsiElement[] allElementsToDelete, final List<UsageInfo> usages) {
        final boolean justPrivates = JavaSafeDeleteProcessor.containsOnlyPrivates(psiClass);
        ReferencesSearch.search((PsiElement)psiClass).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (!JavaSafeDeleteProcessor.isInside(element, allElementsToDelete)) {
                    PsiElement pparent;
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiReferenceList && (pparent = parent.getParent()) instanceof PsiClass) {
                        PsiClass inheritor = (PsiClass)pparent;
                        if (justPrivates && (parent.equals(inheritor.getExtendsList()) || parent.equals(inheritor.getImplementsList()))) {
                            usages.add(new SafeDeleteExtendsClassUsageInfo((PsiJavaCodeReferenceElement)element, psiClass, inheritor));
                            return true;
                        }
                    }
                    LOG.assertTrue(element.getTextRange() != null);
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiClass, parent instanceof PsiImportStatement));
                }
                return true;
            }
        });
    }

    private static boolean containsOnlyPrivates(PsiClass aClass) {
        PsiClass[] inners;
        PsiMethod[] methods;
        PsiField[] fields;
        for (PsiField field : fields = aClass.getFields()) {
            if (field.hasModifierProperty("private")) continue;
            return false;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            PsiReferenceExpression methodExpression;
            PsiExpression expression;
            PsiStatement[] statements;
            PsiCodeBlock body;
            if (method.hasModifierProperty("private") || method.isConstructor() && (body = method.getBody()) != null && ((statements = body.getStatements()).length == 0 || statements.length == 1 && statements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).getText().equals("super"))) continue;
            return false;
        }
        for (PsiClass inner : inners = aClass.getInnerClasses()) {
            if (inner.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    private static void findTypeParameterExternalUsages(final PsiTypeParameter typeParameter, final Collection<UsageInfo> usages) {
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        if (owner != null) {
            final int index = owner.getTypeParameterList().getTypeParameterIndex(typeParameter);
            ReferencesSearch.search((PsiElement)owner).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiTypeElement[] typeArgs;
                    if (reference instanceof PsiJavaCodeReferenceElement && (typeArgs = ((PsiJavaCodeReferenceElement)reference).getParameterList().getTypeParameterElements()).length > index) {
                        usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)typeArgs[index], (PsiElement)typeParameter, true));
                    }
                    return true;
                }
            });
        }
    }

    @Nullable
    private static Condition<PsiElement> findMethodUsages(PsiMethod psiMethod, final PsiElement[] allElementsToDelete, List<UsageInfo> usages) {
        Collection references = ReferencesSearch.search((PsiElement)psiMethod).findAll();
        if (psiMethod.isConstructor()) {
            return JavaSafeDeleteProcessor.findConstructorUsages(psiMethod, references, usages, allElementsToDelete);
        }
        PsiMethod[] overridingMethods = JavaSafeDeleteProcessor.removeDeletedMethods((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)psiMethod.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY), allElementsToDelete);
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, (PsiElement[])overridingMethods)) continue;
            usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiMethod, false));
        }
        HashMap methodToReferences = new HashMap();
        for (PsiMethod overridingMethod : overridingMethods) {
            Collection overridingReferences = ReferencesSearch.search((PsiElement)overridingMethod).findAll();
            methodToReferences.put((Object)overridingMethod, (Object)overridingReferences);
        }
        final Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(psiMethod, references, Arrays.asList(overridingMethods), (HashMap<PsiMethod, Collection<PsiReference>>)methodToReferences, usages, allElementsToDelete);
        return new Condition<PsiElement>(){

            public boolean value(PsiElement usage) {
                if (usage instanceof PsiFile) {
                    return false;
                }
                return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
            }
        };
    }

    private static PsiMethod[] removeDeletedMethods(PsiMethod[] methods, PsiElement[] allElementsToDelete) {
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            boolean isDeleted = false;
            for (PsiElement element : allElementsToDelete) {
                if (element != method) continue;
                isDeleted = true;
                break;
            }
            if (isDeleted) continue;
            list.add(method);
        }
        return list.toArray(new PsiMethod[list.size()]);
    }

    @Nullable
    private static Condition<PsiElement> findConstructorUsages(PsiMethod constructor, Collection<PsiReference> originalReferences, List<UsageInfo> usages, final PsiElement[] allElementsToDelete) {
        HashMap constructorsToRefs = new HashMap();
        HashSet<Object> newConstructors = new HashSet<Object>();
        if (JavaSafeDeleteProcessor.isTheOnlyEmptyDefaultConstructor(constructor)) {
            return null;
        }
        newConstructors.add(constructor);
        constructorsToRefs.put((Object)constructor, originalReferences);
        HashSet<PsiMethod> passConstructors = new HashSet<PsiMethod>();
        do {
            passConstructors.clear();
            for (PsiMethod psiMethod : newConstructors) {
                Collection references = (Collection)constructorsToRefs.get((Object)psiMethod);
                for (PsiReference reference : references) {
                    PsiMethod overridingConstructor = JavaSafeDeleteProcessor.getOverridingConstructorOfSuperCall(reference.getElement());
                    if (overridingConstructor == null || constructorsToRefs.containsKey((Object)overridingConstructor)) continue;
                    Collection overridingConstructorReferences = ReferencesSearch.search((PsiElement)overridingConstructor).findAll();
                    constructorsToRefs.put((Object)overridingConstructor, (Object)overridingConstructorReferences);
                    passConstructors.add(overridingConstructor);
                }
            }
            newConstructors.clear();
            newConstructors.addAll(passConstructors);
        } while (!newConstructors.isEmpty());
        final Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(constructor, originalReferences, constructorsToRefs.keySet(), (HashMap<PsiMethod, Collection<PsiReference>>)constructorsToRefs, usages, allElementsToDelete);
        return new Condition<PsiElement>(){

            public boolean value(PsiElement usage) {
                if (usage instanceof PsiFile) {
                    return false;
                }
                return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
            }
        };
    }

    private static boolean isTheOnlyEmptyDefaultConstructor(PsiMethod constructor) {
        if (constructor.getParameterList().getParameters().length > 0) {
            return false;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body != null && body.getStatements().length > 0) {
            return false;
        }
        return constructor.getContainingClass().getConstructors().length == 1;
    }

    private static Set<PsiMethod> validateOverridingMethods(PsiMethod originalMethod, Collection<PsiReference> originalReferences, Collection<PsiMethod> overridingMethods, HashMap<PsiMethod, Collection<PsiReference>> methodToReferences, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        boolean anyNewBadRefs;
        LinkedHashSet<PsiMethod> validOverriding = new LinkedHashSet<PsiMethod>(overridingMethods);
        HashSet<PsiMethod> multipleInterfaceImplementations = new HashSet<PsiMethod>();
        do {
            anyNewBadRefs = false;
            for (PsiMethod overridingMethod : overridingMethods) {
                PsiElement element;
                if (!validOverriding.contains(overridingMethod)) continue;
                Collection overridingReferences = (Collection)methodToReferences.get((Object)overridingMethod);
                boolean anyOverridingRefs = false;
                for (PsiReference overridingReference : overridingReferences) {
                    element = overridingReference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
                    anyOverridingRefs = true;
                    break;
                }
                if (!anyOverridingRefs && JavaSafeDeleteProcessor.isMultipleInterfacesImplementation(overridingMethod, allElementsToDelete)) {
                    anyOverridingRefs = true;
                    multipleInterfaceImplementations.add(overridingMethod);
                }
                if (!anyOverridingRefs) continue;
                validOverriding.remove(overridingMethod);
                anyNewBadRefs = true;
                for (PsiReference reference : originalReferences) {
                    element = reference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, overridingMethods)) continue;
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)originalMethod, false));
                    validOverriding.clear();
                }
            }
        } while (anyNewBadRefs && !validOverriding.isEmpty());
        for (PsiMethod method : validOverriding) {
            if (method == originalMethod) continue;
            usages.add(new SafeDeleteOverridingMethodUsageInfo(method, originalMethod));
        }
        for (PsiMethod method : overridingMethods) {
            boolean methodCanBePrivate;
            if (validOverriding.contains(method) || multipleInterfaceImplementations.contains(method) || !(methodCanBePrivate = JavaSafeDeleteProcessor.canBePrivate(method, (Collection)methodToReferences.get((Object)method), validOverriding, allElementsToDelete))) continue;
            usages.add(new SafeDeletePrivatizeMethod(method, originalMethod));
        }
        return validOverriding;
    }

    private static boolean isMultipleInterfacesImplementation(PsiMethod method, PsiElement[] allElementsToDelete) {
        PsiMethod[] methods;
        for (PsiMethod superMethod : methods = method.findSuperMethods()) {
            if (ArrayUtil.find((Object[])allElementsToDelete, (Object)superMethod) >= 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiMethod getOverridingConstructorOfSuperCall(PsiElement element) {
        PsiElement parent;
        PsiMethod overridingConstructor = null;
        if (element instanceof PsiReferenceExpression && "super".equals(element.getText()) && (parent = element.getParent()) instanceof PsiMethodCallExpression && (parent = parent.getParent()) instanceof PsiExpressionStatement && (parent = parent.getParent()) instanceof PsiCodeBlock && (parent = parent.getParent()) instanceof PsiMethod && ((PsiMethod)parent).isConstructor()) {
            overridingConstructor = (PsiMethod)parent;
        }
        return overridingConstructor;
    }

    private static boolean canBePrivate(PsiMethod method, Collection<PsiReference> references, Collection<? extends PsiElement> deleted, PsiElement[] allElementsToDelete) {
        PsiModifierList privateModifierList;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiManager manager = method.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        try {
            PsiMethod newMethod = factory.createMethod("x3", PsiType.VOID);
            privateModifierList = newMethod.getModifierList();
            privateModifierList.setModifierProperty("private", true);
        }
        catch (IncorrectOperationException e) {
            LOG.assertTrue(false);
            return false;
        }
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, deleted) || facade.getResolveHelper().isAccessible((PsiMember)method, privateModifierList, element, null, null)) continue;
            return false;
        }
        return true;
    }

    private static Condition<PsiElement> findFieldUsages(final PsiField psiField, final List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        final Condition<PsiElement> isInsideDeleted = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        ReferencesSearch.search((PsiElement)psiField).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                if (!isInsideDeleted.value((Object)reference.getElement())) {
                    PsiElement element = reference.getElement();
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiAssignmentExpression && element == ((PsiAssignmentExpression)parent).getLExpression()) {
                        usages.add(new SafeDeleteFieldWriteReference((PsiAssignmentExpression)parent, psiField));
                    } else {
                        TextRange range = reference.getRangeInElement();
                        usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(reference.getElement(), (PsiElement)psiField, range.getStartOffset(), range.getEndOffset(), false, false));
                    }
                }
                return true;
            }
        });
        return isInsideDeleted;
    }

    private static void findParameterUsages(final PsiParameter parameter, final List<UsageInfo> usages) {
        final PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        final int index = method.getParameterList().getParameterIndex(parameter);
        ReferencesSearch.search((PsiElement)method).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiExpression[] args;
                PsiExpressionList argList;
                PsiElement element = reference.getElement();
                PsiCall call = null;
                if (element instanceof PsiCall) {
                    call = (PsiCall)element;
                } else if (element.getParent() instanceof PsiCall) {
                    call = (PsiCall)element.getParent();
                }
                if (call != null && (argList = call.getArgumentList()) != null && index < (args = argList.getExpressions()).length) {
                    if (!parameter.isVarArgs()) {
                        usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)args[index], (PsiElement)parameter, true));
                    } else {
                        for (int i = index; i < args.length; ++i) {
                            usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)args[i], (PsiElement)parameter, true));
                        }
                    }
                }
                return true;
            }
        });
        ReferencesSearch.search((PsiElement)parameter).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                PsiDocTag docTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
                if (docTag != null) {
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)docTag, (PsiElement)parameter, true));
                    return true;
                }
                boolean isSafeDelete = false;
                if (element.getParent().getParent() instanceof PsiMethodCallExpression) {
                    PsiMethod superMethod;
                    PsiMethodCallExpression call = (PsiMethodCallExpression)element.getParent().getParent();
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.getText().equals("super")) {
                        isSafeDelete = true;
                    } else if (methodExpression.getQualifierExpression() instanceof PsiSuperExpression && (superMethod = call.resolveMethod()) != null && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method)) {
                        isSafeDelete = true;
                    }
                }
                usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, isSafeDelete));
                return true;
            }
        });
    }

    private static boolean isInside(PsiElement place, PsiElement[] ancestors) {
        return JavaSafeDeleteProcessor.isInside(place, Arrays.asList(ancestors));
    }

    private static boolean isInside(PsiElement place, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!JavaSafeDeleteProcessor.isInside(place, psiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(PsiElement place, PsiElement ancestor) {
        PsiJavaFile file;
        PsiClass aClass;
        if (SafeDeleteProcessor.isInside(place, ancestor)) {
            return true;
        }
        return place instanceof PsiComment && ancestor instanceof PsiClass && (aClass = (PsiClass)ancestor).getParent() instanceof PsiJavaFile && PsiTreeUtil.isAncestor((PsiElement)(file = (PsiJavaFile)aClass.getParent()), (PsiElement)place, (boolean)false) && file.getClasses().length == 1;
    }
}

