/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.wrapreturnvalue.WrapReturnValueDialog;
import org.jetbrains.annotations.NotNull;

class WrapReturnValueHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactorJBundle.message("wrap.return.value", new Object[0]);

    WrapReturnValueHandler() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/wrapreturnvalue/WrapReturnValueHandler.invoke must not be null");
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiMethod selectedMethod = null;
        if (element instanceof PsiMethod) {
            selectedMethod = (PsiMethod)element;
        } else {
            CaretModel caretModel = editor.getCaretModel();
            int position = caretModel.getOffset();
            for (PsiElement selectedElement = file.findElementAt(position); selectedElement != null; selectedElement = selectedElement.getParent()) {
                if (!(selectedElement instanceof PsiMethod)) continue;
                selectedMethod = (PsiMethod)selectedElement;
                break;
            }
        }
        if (selectedMethod == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.caret.should.be.positioned.at.the.name.of.the.method.to.be.refactored", new Object[0])), null, (String)this.getHelpID());
            return;
        }
        this.invoke(project, selectedMethod, editor);
    }

    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    protected String getHelpID() {
        return "refactorj.wrapReturnValue";
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/wrapreturnvalue/WrapReturnValueHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/wrapreturnvalue/WrapReturnValueHandler.invoke must not be null");
        }
        if (elements.length != 1) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiMethod.class, (boolean)false);
        if (method == null) {
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        this.invoke(project, method, editor);
    }

    private void invoke(Project project, PsiMethod method, Editor editor) {
        if (method.isConstructor()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("constructor.returns.can.not.be.wrapped", new Object[0])), null, (String)this.getHelpID());
            return;
        }
        PsiType returnType = method.getReturnType();
        if (PsiType.VOID.equals(returnType)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("method.selected.returns.void", new Object[0])), null, (String)this.getHelpID());
            return;
        }
        if ((method = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"))) == null) {
            return;
        }
        if (method instanceof PsiCompiledElement) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.selected.method.cannot.be.wrapped.because.it.is.defined.in.a.non.project.class", new Object[0])), null, (String)this.getHelpID());
            return;
        }
        new WrapReturnValueDialog(method).show();
    }
}

