/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceHandler;
import com.intellij.slicer.SlicePanel;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceToolwindowSettings;
import com.intellij.slicer.SliceUsage;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

@State(name="SliceManager", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class SliceManager
implements PersistentStateComponent<StoredSettingsBean> {
    private final Project myProject;
    private final ContentManager myBackContentManager;
    private final ContentManager myForthContentManager;
    private volatile boolean myCanceled;
    private final StoredSettingsBean myStoredSettings;
    private static final String BACK_TOOLWINDOW_ID = "Analyze Dataflow to";
    private static final String FORTH_TOOLWINDOW_ID = "Analyze Dataflow from";

    public static SliceManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceManager.getInstance must not be null");
        }
        return (SliceManager)ServiceManager.getService((Project)project, SliceManager.class);
    }

    public SliceManager(@NotNull Project project, @NotNull ToolWindowManager toolWindowManager, PsiManager psiManager) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceManager.<init> must not be null");
        }
        if (toolWindowManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceManager.<init> must not be null");
        }
        this.myStoredSettings = new StoredSettingsBean();
        this.myProject = project;
        ToolWindow backToolWindow = toolWindowManager.registerToolWindow(BACK_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
        this.myBackContentManager = backToolWindow.getContentManager();
        new ContentManagerWatcher(backToolWindow, this.myBackContentManager);
        ToolWindow forthToolWindow = toolWindowManager.registerToolWindow(FORTH_TOOLWINDOW_ID, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
        this.myForthContentManager = forthToolWindow.getContentManager();
        new ContentManagerWatcher(forthToolWindow, this.myForthContentManager);
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void beforeChildAddition(PsiTreeChangeEvent event) {
                SliceManager.this.cancel();
            }

            public void beforeChildRemoval(PsiTreeChangeEvent event) {
                SliceManager.this.cancel();
            }

            public void beforeChildReplacement(PsiTreeChangeEvent event) {
                SliceManager.this.cancel();
            }

            public void beforeChildMovement(PsiTreeChangeEvent event) {
                SliceManager.this.cancel();
            }

            public void beforeChildrenChange(PsiTreeChangeEvent event) {
                SliceManager.this.cancel();
            }

            public void beforePropertyChange(PsiTreeChangeEvent event) {
                SliceManager.this.cancel();
            }
        }, (Disposable)project);
    }

    private void cancel() {
        this.myCanceled = true;
    }

    public void slice(@NotNull PsiElement element, boolean dataFlowToThis, SliceHandler handler) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceManager.slice must not be null");
        }
        String dialogTitle = SliceManager.getElementDescription((dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID) + " ", element, null);
        dialogTitle = Pattern.compile("<[^<>]*>").matcher(dialogTitle).replaceAll("");
        SliceAnalysisParams params = handler.askForParams(element, dataFlowToThis, this.myStoredSettings, dialogTitle);
        if (params == null) {
            return;
        }
        SliceRootNode rootNode = new SliceRootNode(this.myProject, new DuplicateMap(), SliceManager.createRootUsage(element, params));
        this.createToolWindow(dataFlowToThis, rootNode, false, SliceManager.getElementDescription(null, element, null));
    }

    public void createToolWindow(boolean dataFlowToThis, SliceRootNode rootNode, boolean splitByLeafExpressions, String displayName) {
        final SliceToolwindowSettings sliceToolwindowSettings = SliceToolwindowSettings.getInstance(this.myProject);
        final ContentManager contentManager = dataFlowToThis ? this.myBackContentManager : this.myForthContentManager;
        final Content[] myContent = new Content[1];
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(dataFlowToThis ? BACK_TOOLWINDOW_ID : FORTH_TOOLWINDOW_ID);
        SlicePanel slicePanel = new SlicePanel(this.myProject, dataFlowToThis, rootNode, splitByLeafExpressions, toolWindow){

            @Override
            protected void close() {
                contentManager.removeContent(myContent[0], true);
            }

            @Override
            public boolean isAutoScroll() {
                return sliceToolwindowSettings.isAutoScroll();
            }

            @Override
            public void setAutoScroll(boolean autoScroll) {
                sliceToolwindowSettings.setAutoScroll(autoScroll);
            }

            @Override
            public boolean isPreview() {
                return sliceToolwindowSettings.isPreview();
            }

            @Override
            public void setPreview(boolean preview) {
                sliceToolwindowSettings.setPreview(preview);
            }
        };
        myContent[0] = contentManager.getFactory().createContent((JComponent)slicePanel, displayName, true);
        contentManager.addContent(myContent[0]);
        contentManager.setSelectedContent(myContent[0]);
        toolWindow.activate(null);
    }

    public static String getElementDescription(String prefix, PsiElement element, String suffix) {
        PsiElement elementToSlice = element;
        if (element instanceof PsiReferenceExpression) {
            elementToSlice = ((PsiReferenceExpression)element).resolve();
        }
        if (elementToSlice == null) {
            elementToSlice = element;
        }
        String desc = ElementDescriptionUtil.getElementDescription((PsiElement)elementToSlice, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT);
        return "<html>" + (prefix == null ? "" : prefix) + StringUtil.first((String)desc, (int)100, (boolean)true) + (suffix == null ? "" : suffix) + "</html>";
    }

    public static SliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceManager.createRootUsage must not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceManager.createRootUsage must not be null");
        }
        return new SliceUsage(element, params);
    }

    public void checkCanceled() throws ProcessCanceledException {
        if (this.myCanceled) {
            throw new ProcessCanceledException();
        }
    }

    public void runInterruptibly(Runnable runnable, Runnable onCancel, ProgressIndicator progress) throws ProcessCanceledException {
        this.myCanceled = false;
        try {
            progress.checkCanceled();
            ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(runnable, progress);
        }
        catch (ProcessCanceledException e) {
            this.cancel();
            progress.cancel();
            onCancel.run();
            throw e;
        }
    }

    public StoredSettingsBean getState() {
        return this.myStoredSettings;
    }

    public void loadState(StoredSettingsBean state) {
        this.myStoredSettings.analysisUIOptions.save(state.analysisUIOptions);
    }

    public static class StoredSettingsBean {
        public boolean showDereferences = true;
        public AnalysisUIOptions analysisUIOptions = new AnalysisUIOptions();
    }
}

