/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    @NotNull
    private final VirtualFile mySourceRoot;
    private final boolean myUsePlatformSourceRoot;

    public LightTempDirTestFixtureImpl() {
        this.mySourceRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        this.myUsePlatformSourceRoot = false;
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        this.myUsePlatformSourceRoot = usePlatformSourceRoot;
        this.mySourceRoot = null;
    }

    @Override
    public VirtualFile copyFile(final VirtualFile file, final String targetPath) {
        final String path = PathUtil.getParentPath((String)targetPath);
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile targetDir = LightTempDirTestFixtureImpl.this.findOrCreateDir(path);
                    return VfsUtil.copyFile((Object)this, (VirtualFile)file, (VirtualFile)targetDir, (String)PathUtil.getFileName((String)targetPath));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(final String path) {
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile root = LightTempDirTestFixtureImpl.this.getSourceRoot();
                if (path.length() == 0) {
                    return root;
                }
                String trimPath = StringUtil.trimStart((String)path, (String)"/");
                List dirs = StringUtil.split((String)trimPath, (String)"/");
                for (String dirName : dirs) {
                    VirtualFile dir = root.findChild(dirName);
                    if (dir != null) {
                        root = dir;
                        continue;
                    }
                    try {
                        root = root.createChildDirectory((Object)this, dirName);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return root;
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl.findOrCreateDir must not return null");
        }
        return virtualFile;
    }

    @Override
    public VirtualFile copyAll(final String dataDir, final String targetDir) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                assert (from != null) : "Cannot find testdata directory " + dataDir;
                try {
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (targetDir.length() > 0) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, null);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        VirtualFile child;
        String thisLevel = relativePath;
        String nextLevel = null;
        int pos = relativePath.indexOf(47);
        if (pos > 0) {
            thisLevel = relativePath.substring(0, pos);
            nextLevel = relativePath.substring(pos + 1);
        }
        if ((child = root.findChild(thisLevel)) == null) {
            child = root.createChildDirectory((Object)this, thisLevel);
        }
        if (nextLevel != null && nextLevel.length() > 0) {
            return this.findOrCreateChildDir(child, nextLevel);
        }
        return child;
    }

    @Override
    public String getTempDirPath() {
        return "temp:///";
    }

    @Override
    public VirtualFile getFile(@NonNls String path) {
        VirtualFile sourceRoot = this.getSourceRoot();
        VirtualFile result = sourceRoot.findFileByRelativePath(path);
        if (result == null) {
            sourceRoot.refresh(false, true);
            return sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(String targetPath) {
        final String path = PathUtil.getParentPath((String)targetPath);
        final String name = PathUtil.getFileName((String)targetPath);
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile targetDir = LightTempDirTestFixtureImpl.this.findOrCreateDir(path);
                    return targetDir.createChildData((Object)this, name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl.createFile must not return null");
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(String targetPath, final String text) throws IOException {
        final VirtualFile file = this.createFile(targetPath);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    VfsUtil.saveText((VirtualFile)file, (String)text);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl.createFile must not return null");
        }
        return virtualFile;
    }

    public void deleteAll() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile[] children;
                for (VirtualFile child : children = LightTempDirTestFixtureImpl.this.getSourceRoot().getChildren()) {
                    try {
                        child.delete((Object)this);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private VirtualFile getSourceRoot() {
        VirtualFile virtualFile;
        if (this.myUsePlatformSourceRoot) {
            virtualFile = LightPlatformTestCase.getSourceRoot();
            if (virtualFile == null) throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl.getSourceRoot must not return null");
            return virtualFile;
        }
        virtualFile = this.mySourceRoot;
        if (virtualFile != null) return virtualFile;
        throw new IllegalStateException("@NotNull method com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl.getSourceRoot must not return null");
    }
}

